/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.messages;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.messages.SearchMessagesForm;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageBox;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.messages.MessageQuery;
import nl.strohalm.cyclos.services.elements.MessageService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchMessagesAction
extends BaseQueryAction {
    private DataBinder<MessageQuery> dataBinder;
    private MessageService messageService;

    public DataBinder<MessageQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MessageQuery> binder = BeanBinder.instance(MessageQuery.class);
            binder.registerBinder("messageBox", PropertyBinder.instance(MessageBox.class, "messageBox"));
            binder.registerBinder("rootType", PropertyBinder.instance(Message.RootType.class, "rootType"));
            binder.registerBinder("relatedMember", PropertyBinder.instance(Member.class, "relatedMember"));
            binder.registerBinder("category", PropertyBinder.instance(MessageCategory.class, "category"));
            binder.registerBinder("keywords", PropertyBinder.instance(String.class, "keywords"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        List<Message> list = this.messageService.search((MessageQuery)queryParameters);
        context.getRequest().setAttribute("messages", list);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchMessagesForm form = (SearchMessagesForm)((Object)context.getForm());
        MessageQuery query = this.getDataBinder().readFromString(form.getQuery());
        MessageBox messageBox = query.getMessageBox();
        if (messageBox == null) {
            throw new ValidationException();
        }
        if (query.getRelatedMember() != null) {
            Member relatedMember = (Member)this.elementService.load(query.getRelatedMember().getId(), Element.Relationships.USER);
            request.setAttribute("relatedMember", (Object)relatedMember);
        }
        query.fetch(Message.Relationships.FROM_MEMBER, Message.Relationships.TO_MEMBER, Message.Relationships.TO_GROUPS);
        request.setAttribute("messageBox", (Object)messageBox);
        RequestHelper.storeEnum(request, MessageBox.class, "messageBoxes");
        RequestHelper.storeEnum(request, Message.RootType.class, "rootTypes");
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)context.getGroup();
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), SystemGroup.Relationships.MESSAGE_CATEGORIES);
            request.setAttribute("categories", adminGroup.getMessageCategories());
        }
        boolean canSend = false;
        if (context.isMember()) {
            canSend = this.permissionService.hasPermission(MemberPermission.MESSAGES_SEND_TO_MEMBER) || this.permissionService.hasPermission(MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION) || this.permissionService.hasPermission(BrokerPermission.MESSAGES_SEND_TO_MEMBERS);
        } else if (context.isOperator()) {
            canSend = this.permissionService.hasPermission(OperatorPermission.MESSAGES_SEND_TO_MEMBER) || this.permissionService.hasPermission(OperatorPermission.MESSAGES_SEND_TO_ADMINISTRATION);
        } else if (context.isAdmin()) {
            canSend = this.permissionService.hasPermission(AdminMemberPermission.MESSAGES_SEND_TO_MEMBER) || this.permissionService.hasPermission(AdminMemberPermission.MESSAGES_SEND_TO_GROUP);
        }
        request.setAttribute("canSend", (Object)canSend);
        boolean canManage = false;
        if (context.isMember()) {
            canManage = this.permissionService.hasPermission(MemberPermission.MESSAGES_MANAGE);
        } else if (context.isOperator()) {
            canManage = this.permissionService.hasPermission(OperatorPermission.MESSAGES_MANAGE);
        } else if (context.isAdmin()) {
            canManage = this.permissionService.hasPermission(AdminMemberPermission.MESSAGES_MANAGE);
        }
        request.setAttribute("canManage", (Object)canManage);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }
}

