/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.messages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.messages.SendMessageForm;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.messages.MessageCategoryQuery;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.elements.MessageCategoryService;
import nl.strohalm.cyclos.services.elements.MessageService;
import nl.strohalm.cyclos.services.elements.SendDirectMessageToMemberDTO;
import nl.strohalm.cyclos.services.elements.SendMessageDTO;
import nl.strohalm.cyclos.services.elements.SendMessageFromBrokerToMembersDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToAdminDTO;
import nl.strohalm.cyclos.services.elements.SendMessageToGroupDTO;
import nl.strohalm.cyclos.services.elements.exceptions.MemberWontReceiveNotificationException;
import nl.strohalm.cyclos.services.preferences.PreferenceService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.TextFormat;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.StringTrimmerConverter;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.struts.action.ActionForward;

public class SendMessageAction
extends BaseFormAction {
    private static final int WRAP_SIZE = 50;
    private MessageService messageService;
    private MessageCategoryService messageCategoryService;
    private PreferenceService preferenceService;
    private Map<Class<? extends SendMessageDTO>, DataBinder<? extends SendMessageDTO>> dataBindersByType;

    @Inject
    public void setMessageCategoryService(MessageCategoryService messageCategoryService) {
        this.messageCategoryService = messageCategoryService;
    }

    @Inject
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Inject
    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        SendMessageForm form = (SendMessageForm)((Object)context.getForm());
        long toMemberId = form.getToMemberId();
        SendMessageDTO dto = this.resolveDTO(context);
        try {
            String key = "message.sent";
            this.messageService.send(dto);
            if (dto instanceof SendDirectMessageToMemberDTO) {
                SendDirectMessageToMemberDTO sendDirectMessageToMemberDTO = (SendDirectMessageToMemberDTO)dto;
                Message.Type type = null;
                type = context.isAdmin() ? Message.Type.FROM_ADMIN_TO_MEMBER : Message.Type.FROM_MEMBER;
                if (CurrentTransactionData.hasMailError()) {
                    Member member = sendDirectMessageToMemberDTO.getToMember();
                    NotificationPreference np = this.preferenceService.load(member, type);
                    if (np.isMessage()) {
                        key = "message.warning.messageNotReceivedByEmail";
                    } else {
                        return context.sendError("message.error.emailNotSent", new Object[0]);
                    }
                }
            }
            context.sendMessage(key, new Object[0]);
        }
        catch (MemberWontReceiveNotificationException e) {
            return context.sendError("message.error.memberWontReceiveNotification", new Object[0]);
        }
        if (dto.getInReplyTo() == null && toMemberId > 0L) {
            return ActionHelper.redirectWithParam(context.getRequest(), context.findForward("backToProfile"), "memberId", toMemberId);
        }
        return context.findForward("backToList");
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        SendMessageForm form = (SendMessageForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        Member toMember = this.resolveToMember(context);
        Message inReplyTo = this.resolveInReplyTo(context);
        if (toMember == null) {
            ArrayList<SendTo> sendTo = new ArrayList<SendTo>();
            if (context.isAdmin()) {
                if (inReplyTo == null) {
                    GroupQuery gq = new GroupQuery();
                    gq.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
                    gq.setStatus(Group.Status.NORMAL);
                    request.setAttribute("groups", this.groupService.search(gq));
                    if (this.permissionService.hasPermission(AdminMemberPermission.MESSAGES_SEND_TO_MEMBER)) {
                        sendTo.add(SendTo.MEMBER);
                    }
                    if (this.permissionService.hasPermission(AdminMemberPermission.MESSAGES_SEND_TO_GROUP)) {
                        sendTo.add(SendTo.GROUP);
                    }
                }
            } else if (form.isToBrokeredMembers()) {
                if (context.isBroker() && this.permissionService.hasPermission(BrokerPermission.MESSAGES_SEND_TO_MEMBERS)) {
                    sendTo.add(SendTo.BROKERED_MEMBERS);
                    request.setAttribute("toBrokeredMembers", (Object)SendTo.BROKERED_MEMBERS);
                }
            } else if (inReplyTo == null) {
                if (context.isMember() && this.permissionService.hasPermission(MemberPermission.MESSAGES_SEND_TO_MEMBER) || context.isOperator() && this.permissionService.hasPermission(OperatorPermission.MESSAGES_SEND_TO_MEMBER)) {
                    sendTo.add(SendTo.MEMBER);
                }
                if (context.isBroker() && this.permissionService.hasPermission(BrokerPermission.MESSAGES_SEND_TO_MEMBERS)) {
                    sendTo.add(SendTo.BROKERED_MEMBERS);
                }
                MessageCategoryQuery query = new MessageCategoryQuery();
                query.setFromElement((Member)context.getAccountOwner());
                List<MessageCategory> categories = this.messageCategoryService.search(query);
                request.setAttribute("categories", categories);
                if (CollectionUtils.isNotEmpty(categories) && (context.isMember() && this.permissionService.hasPermission(MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION) || context.isOperator() && this.permissionService.hasPermission(OperatorPermission.MESSAGES_SEND_TO_ADMINISTRATION))) {
                    sendTo.add(SendTo.ADMIN);
                }
            }
            if (inReplyTo == null && CollectionUtils.isEmpty(sendTo)) {
                throw new PermissionDeniedException();
            }
            request.setAttribute("sendTo", sendTo);
        } else {
            MessageCategoryQuery query = new MessageCategoryQuery();
            query.setFromElement((Element)((Object)(context.isOperator() ? context.getAccountOwner() : context.getElement())));
            query.setToElement(toMember);
            request.setAttribute("categories", this.messageCategoryService.search(query));
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TextFormat messageFormat = localSettings.getMessageFormat();
        if (inReplyTo != null) {
            String body;
            form.setMessage("subject", context.message("message.reply.subject", inReplyTo.getSubject()));
            if (inReplyTo.isHtml()) {
                body = "<br><br><div style='padding-left:40px;border-left:1px solid black'>" + inReplyTo.getBody() + "</div>";
                messageFormat = TextFormat.RICH;
            } else {
                body = " \n\n> " + StringUtils.replace((String)WordUtils.wrap((String)inReplyTo.getBody(), (int)50), (String)"\n", (String)"\n> ");
                messageFormat = TextFormat.PLAIN;
            }
            request.setAttribute("body", (Object)body);
            form.setMessage("html", inReplyTo.isHtml());
            if (inReplyTo.getCategory() != null) {
                form.setMessage("category", inReplyTo.getCategory().getId());
                if (inReplyTo.getToMember() != null) {
                    request.setAttribute("categoryName", (Object)inReplyTo.getCategory().getName());
                    request.setAttribute("categoryEditable", (Object)false);
                } else {
                    MessageCategoryQuery query = new MessageCategoryQuery();
                    query.setFromElement((Element)((Object)(context.isOperator() ? context.getAccountOwner() : context.getElement())));
                    request.setAttribute("categories", this.messageCategoryService.search(query));
                    request.setAttribute("categoryId", (Object)inReplyTo.getCategory().getId());
                }
            }
        }
        form.setMessage("html", messageFormat == TextFormat.RICH);
        request.setAttribute("inReplyTo", (Object)inReplyTo);
        request.setAttribute("toMember", (Object)toMember);
        request.setAttribute("messageFormat", (Object)messageFormat);
    }

    @Override
    protected void validateForm(ActionContext context) {
        SendMessageDTO dto = this.resolveDTO(context);
        this.messageService.validate(dto);
    }

    private <T extends SendMessageDTO> BeanBinder<T> basicDataBinderFor(Class<T> type) {
        BeanBinder<T> binder = BeanBinder.instance(type);
        binder.registerBinder("category", PropertyBinder.instance(MessageCategory.class, "category"));
        binder.registerBinder("subject", PropertyBinder.instance(String.class, "subject"));
        binder.registerBinder("inReplyTo", PropertyBinder.instance(Message.class, "inReplyTo"));
        binder.registerBinder("html", PropertyBinder.instance(Boolean.TYPE, "html"));
        return binder;
    }

    private <T extends SendMessageDTO> DataBinder<T> getDataBinderFor(Class<T> type) {
        if (this.dataBindersByType == null) {
            this.dataBindersByType = new HashMap<Class<? extends SendMessageDTO>, DataBinder<? extends SendMessageDTO>>();
            BeanBinder<SendDirectMessageToMemberDTO> toMemberBinder = this.basicDataBinderFor(SendDirectMessageToMemberDTO.class);
            toMemberBinder.registerBinder("toMember", PropertyBinder.instance(Member.class, "toMember"));
            this.dataBindersByType.put(SendDirectMessageToMemberDTO.class, toMemberBinder);
            BeanBinder<SendMessageToAdminDTO> toAdminBinder = this.basicDataBinderFor(SendMessageToAdminDTO.class);
            this.dataBindersByType.put(SendMessageToAdminDTO.class, toAdminBinder);
            BeanBinder<SendMessageFromBrokerToMembersDTO> toBrokeredBinder = this.basicDataBinderFor(SendMessageFromBrokerToMembersDTO.class);
            this.dataBindersByType.put(SendMessageFromBrokerToMembersDTO.class, toBrokeredBinder);
            BeanBinder<SendMessageToGroupDTO> toGroupBinder = this.basicDataBinderFor(SendMessageToGroupDTO.class);
            toGroupBinder.registerBinder("toGroups", SimpleCollectionBinder.instance(MemberGroup.class, "toGroups"));
            this.dataBindersByType.put(SendMessageToGroupDTO.class, toGroupBinder);
        }
        return this.dataBindersByType.get(type);
    }

    private SendMessageDTO resolveDTO(ActionContext context) {
        SendMessageForm form = (SendMessageForm)((Object)context.getForm());
        Class dtoClass = null;
        SendTo sendTo = CoercionHelper.coerce(SendTo.class, form.getSendTo());
        if (sendTo == null) {
            throw new ValidationException();
        }
        switch (sendTo) {
            case MEMBER: {
                dtoClass = SendDirectMessageToMemberDTO.class;
                break;
            }
            case GROUP: {
                if (!context.isAdmin()) {
                    throw new ValidationException();
                }
                dtoClass = SendMessageToGroupDTO.class;
                break;
            }
            case BROKERED_MEMBERS: {
                if (!context.isBroker()) {
                    throw new ValidationException();
                }
                dtoClass = SendMessageFromBrokerToMembersDTO.class;
                break;
            }
            case ADMIN: {
                if (!context.isMember() && !context.isOperator()) {
                    throw new ValidationException();
                }
                dtoClass = SendMessageToAdminDTO.class;
                break;
            }
            default: {
                throw new ValidationException();
            }
        }
        SendMessageDTO dto = this.getDataBinderFor(dtoClass).readFromString(form.getMessage());
        if (dto.isHtml()) {
            dto.setBody(HtmlConverter.instance().valueOf("" + form.getMessage("body")));
        } else {
            dto.setBody(StringTrimmerConverter.instance().valueOf("" + form.getMessage("body")));
        }
        return dto;
    }

    private Message resolveInReplyTo(ActionContext context) {
        SendMessageForm form = (SendMessageForm)((Object)context.getForm());
        long inReplyToId = form.getInReplyTo();
        if (inReplyToId <= 0L) {
            return null;
        }
        Message inReplyTo = this.messageService.load(inReplyToId, Message.Relationships.TO_MEMBER);
        if (context.isAdmin() && inReplyTo.getToMember() != null || context.isMember() && !context.getAccountOwner().equals(inReplyTo.getToMember())) {
            throw new PermissionDeniedException();
        }
        return inReplyTo;
    }

    private Member resolveToMember(ActionContext context) {
        SendMessageForm form = (SendMessageForm)((Object)context.getForm());
        long toMemberId = form.getToMemberId();
        Member toMember = null;
        if (toMemberId > 0L) {
            Element loggedElement = (Element)((Object)(context.isOperator() ? context.getAccountOwner() : context.getElement()));
            if (toMemberId == loggedElement.getId()) {
                throw new ValidationException();
            }
            Object element = this.elementService.load(toMemberId, Element.Relationships.USER);
            if (!(element instanceof Member)) {
                throw new ValidationException();
            }
            toMember = (Member)element;
        }
        return toMember;
    }

    public static enum SendTo {
        MEMBER,
        ADMIN,
        GROUP,
        BROKERED_MEMBERS;

    }
}

