/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.messages;

import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.messages.ViewMessageForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.elements.MessageService;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ViewMessageAction
extends BaseAction {
    private static final Relationship[] FETCH = new Relationship[]{Message.Relationships.FROM_MEMBER, Message.Relationships.TO_MEMBER, Message.Relationships.TO_GROUPS, Message.Relationships.CATEGORY};
    private MessageService messageService;

    @Inject
    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ViewMessageForm form = (ViewMessageForm)((Object)context.getForm());
        long id = form.getMessageId();
        if (id <= 0L) {
            Long lastMessageId = (Long)context.getSession().getAttribute("lastMessageId");
            if (lastMessageId == null) {
                throw new ValidationException();
            }
            id = lastMessageId;
        }
        Message message = this.messageService.read(id, FETCH);
        context.getSession().setAttribute("lastMessageId", (Object)message.getId());
        Member owner = message.getOwner();
        Object element = context.getElement();
        if (owner == null && !context.isAdmin() || context.isMember() && !((Entity)element).equals(owner)) {
            throw new PermissionDeniedException();
        }
        context.getRequest().setAttribute("message", (Object)message);
        context.getRequest().setAttribute("canManageMessage", (Object)this.messageService.canManage(message));
        if (message.getFromMember() == null) {
            context.getRequest().setAttribute("canReplyMessage", (Object)this.messageService.canSendToAdmin());
        } else {
            context.getRequest().setAttribute("canReplyMessage", (Object)this.messageService.canSendToMember(message.getFromMember()));
        }
        return context.getInputForward();
    }
}

