/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.pending;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.members.pending.SearchPendingMembersAction;
import nl.strohalm.cyclos.controls.members.pending.SearchPendingMembersForm;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.entities.settings.AccessSettings;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;

public class ExportPendingMembersToCsvAction
extends BaseCsvAction {
    private DataBinder<PendingMemberQuery> dataBinder;
    private MemberCustomFieldService memberCustomFieldService;

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    protected List<?> executeQuery(ActionContext context) {
        SearchPendingMembersForm form = (SearchPendingMembersForm)((Object)context.getForm());
        PendingMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(PendingMember.Relationships.CUSTOM_VALUES, PendingMember.Relationships.MEMBER, RelationshipHelper.nested(PendingMember.Relationships.BROKER));
        return this.elementService.search(query);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        return "pending_members_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        AccessSettings accessSettings = this.settingsService.getAccessSettings();
        CSVWriter<PendingMember> csv = CSVWriter.instance(PendingMember.class, settings);
        if (accessSettings.getUsernameGeneration() == AccessSettings.UsernameGeneration.NONE) {
            csv.addColumn(context.message("member.username", new Object[0]), "username");
        }
        csv.addColumn(context.message("member.name", new Object[0]), "name");
        csv.addColumn(context.message("member.email", new Object[0]), "email");
        csv.addColumn(context.message("member.creationDate", new Object[0]), "creationDate", settings.getDateConverter());
        csv.addColumn(context.message("member.group", new Object[0]), "memberGroup.name");
        List customFields = this.memberCustomFieldService.list();
        for (MemberCustomField field : customFields) {
            csv.addColumn(field.getName(), "customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        if (context.isAdmin()) {
            csv.addColumn(context.message("member.brokerUsername", new Object[0]), "broker.username");
            csv.addColumn(context.message("member.brokerName", new Object[0]), "broker.name");
        }
        return csv;
    }

    private DataBinder<PendingMemberQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            this.dataBinder = SearchPendingMembersAction.createDataBinder(settings);
        }
        return this.dataBinder;
    }
}

