/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.pending;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.pending.PendingMemberProfileForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class PendingMemberProfileAction
extends BaseFormAction {
    private MemberCustomFieldService memberCustomFieldService;
    private BeanBinder<PendingMember> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public BeanBinder<PendingMember> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberCustomFieldValue> customValueBinder = BeanBinder.instance(MemberCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(CustomField.class, "field", ReferenceConverter.instance(CustomField.class)));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
            customValueBinder.registerBinder("hidden", PropertyBinder.instance(Boolean.TYPE, "hidden"));
            BeanBinder<PendingMember> binder = BeanBinder.instance(PendingMember.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id"));
            binder.registerBinder("username", PropertyBinder.instance(String.class, "username"));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("broker", PropertyBinder.instance(Member.class, "broker"));
            binder.registerBinder("email", PropertyBinder.instance(String.class, "email"));
            binder.registerBinder("hideEmail", PropertyBinder.instance(Boolean.TYPE, "hideEmail"));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        PendingMemberProfileForm form = (PendingMemberProfileForm)((Object)context.getForm());
        PendingMember pendingMember = this.elementService.loadPendingMember(form.getPendingMemberId(), new Relationship[0]);
        this.getDataBinder().readInto(pendingMember, form.getPendingMember(), true);
        if (context.isBroker()) {
            Member loggedBroker = (Member)context.getElement();
            pendingMember.setBroker(loggedBroker);
        }
        pendingMember = this.elementService.update(pendingMember);
        context.sendMessage("pendingMember.updated", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "pendingMemberId", pendingMember.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        PendingMemberProfileForm form = (PendingMemberProfileForm)((Object)context.getForm());
        long id = form.getPendingMemberId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        PendingMember pendingMember = this.elementService.loadPendingMember(id, PendingMember.Relationships.values());
        request.setAttribute("pendingMember", (Object)pendingMember);
        List<MemberCustomField> customFields = this.customFieldHelper.onlyForGroup(this.memberCustomFieldService.list(), pendingMember.getMemberGroup());
        Iterator<MemberCustomField> iterator = customFields.iterator();
        while (iterator.hasNext()) {
            MemberCustomField customField = iterator.next();
            if (customField.getVisibilityAccess().granted((Group)context.getGroup(), false, context.isBroker(), true, false)) continue;
            iterator.remove();
        }
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, pendingMember.getCustomValues()));
        boolean editable = false;
        if (context.isAdmin()) {
            editable = this.permissionService.hasPermission(AdminMemberPermission.MEMBERS_MANAGE_PENDING);
        } else if (context.isBroker()) {
            editable = this.permissionService.hasPermission(BrokerPermission.MEMBERS_MANAGE_PENDING);
        }
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected void validateForm(ActionContext context) {
        PendingMemberProfileForm form = (PendingMemberProfileForm)((Object)context.getForm());
        PendingMember pendingMember = this.getDataBinder().readFromString(form.getPendingMember());
        this.elementService.validate(pendingMember);
    }
}

