/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.pending;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.members.pending.SearchPendingMembersAction;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.commons.lang.StringUtils;

public class PrintPendingMembersAction
extends SearchPendingMembersAction {
    @Override
    protected Integer pageSize(ActionContext context) {
        return null;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        PendingMemberQuery query = (PendingMemberQuery)super.prepareForm(context);
        query.fetch(PendingMember.Relationships.CUSTOM_VALUES, RelationshipHelper.nested(PendingMember.Relationships.BROKER, Element.Relationships.USER));
        LinkedList customFields = new LinkedList(this.memberCustomFieldService.list());
        Iterator it = customFields.iterator();
        while (it.hasNext()) {
            MemberCustomField field = (MemberCustomField)it.next();
            if (field.isShowInPrint()) continue;
            it.remove();
        }
        request.setAttribute("memberFields", customFields);
        if (context.isAdmin()) {
            LinkedList<String> groupNames = new LinkedList<String>();
            Collection groups = this.groupService.load(EntityHelper.toIdsAsList(query.getGroups()), new Relationship[0]);
            for (Group group : groups) {
                groupNames.add(group.getName());
            }
            request.setAttribute("groupNames", (Object)StringUtils.join(groupNames.iterator(), (String)", "));
        }
        return query;
    }
}

