/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.pending;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.pending.SearchPendingMembersForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PendingMemberQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.beanutils.BeanComparator;

public class SearchPendingMembersAction
extends BaseQueryAction {
    protected MemberCustomFieldService memberCustomFieldService;
    private DataBinder<PendingMemberQuery> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private CustomFieldHelper customFieldHelper;

    public static BeanBinder<PendingMemberQuery> createDataBinder(LocalSettings settings) {
        BeanBinder<PendingMemberQuery> binder = BeanBinder.instance(PendingMemberQuery.class);
        BeanBinder<MemberCustomFieldValue> customValueBinder = BeanBinder.instance(MemberCustomFieldValue.class);
        customValueBinder.registerBinder("field", PropertyBinder.instance(MemberCustomField.class, "field"));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
        binder.registerBinder("broker", PropertyBinder.instance(Member.class, "broker"));
        binder.registerBinder("creationPeriod", DataBinderHelper.periodBinder(settings, "creationPeriod"));
        binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public MemberCustomFieldService getMemberCustomFieldService() {
        return this.memberCustomFieldService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            super.onLocalSettingsUpdate(event);
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberCustomFieldService(MemberCustomFieldService memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        PendingMemberQuery query = (PendingMemberQuery)queryParameters;
        HttpServletRequest request = context.getRequest();
        request.setAttribute("pendingMembers", this.elementService.search(query));
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        Collection<MemberGroup> allowedGroups;
        SystemGroup group;
        HttpServletRequest request = context.getRequest();
        SearchPendingMembersForm form = (SearchPendingMembersForm)((Object)context.getForm());
        PendingMemberQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (query.getBroker() != null) {
            query.setBroker((Member)this.elementService.load(query.getBroker().getId(), new Relationship[0]));
        }
        List<MemberCustomField> fields = this.customFieldHelper.onlyForMemberSearch(this.memberCustomFieldService.list());
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(fields, query.getCustomValues()));
        if (context.isAdmin()) {
            group = (AdminGroup)this.groupService.reload(((Entity)context.getGroup()).getId(), AdminGroup.Relationships.MANAGES_GROUPS);
            allowedGroups = ((AdminGroup)group).getManagesGroups();
        } else if (context.isBroker()) {
            group = (BrokerGroup)this.groupService.reload(((Entity)context.getGroup()).getId(), BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS);
            allowedGroups = ((BrokerGroup)group).getPossibleInitialGroups();
        } else {
            throw new ValidationException();
        }
        ArrayList<MemberGroup> groups = new ArrayList<MemberGroup>(allowedGroups);
        Collections.sort(groups, new BeanComparator("name"));
        request.setAttribute("groups", groups);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<PendingMemberQuery> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings settings = this.settingsService.getLocalSettings();
                this.dataBinder = SearchPendingMembersAction.createDataBinder(settings);
            }
            DataBinder<PendingMemberQuery> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

