/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.pending;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.BasePublicAction;
import nl.strohalm.cyclos.controls.members.pending.ValidateRegistrationForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.exceptions.RegistrationAgreementNotAcceptedException;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ValidateRegistrationAction
extends BasePublicAction {
    private GroupFilterService groupFilterService;
    private CustomizationHelper customizationHelper;

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Override
    protected ActionForward executeAction(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean inContainerPage;
        PendingMember pendingMember;
        HttpSession session = request.getSession(false);
        Enumeration attributeNames = session.getAttributeNames();
        ArrayList<String> attributesToBeRemoved = new ArrayList<String>();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            if ("inContainerPage".equals(name)) continue;
            attributesToBeRemoved.add(name);
        }
        for (String name : attributesToBeRemoved) {
            session.removeAttribute(name);
        }
        String validationKeyMessage = this.messageHelper.message("pendingMember.validationKey", new Object[0]);
        ValidateRegistrationForm form = (ValidateRegistrationForm)actionForm;
        String key = form.getKey();
        try {
            pendingMember = this.elementService.loadPendingMemberByKey(key, PendingMember.Relationships.MEMBER_GROUP);
        }
        catch (EntityNotFoundException e) {
            return ActionHelper.sendError(mapping, request, response, "errors.invalid", validationKeyMessage);
        }
        String containerUrl = this.findContainerUrl(pendingMember);
        if (containerUrl != null && !(inContainerPage = Boolean.TRUE.equals(session.getAttribute("inContainerPage")))) {
            session.setAttribute("inContainerPage", (Object)true);
            session.setAttribute("instantRedirectTo", (Object)(request.getContextPath() + "/do" + mapping.getPath() + "?key=" + key));
            return new ActionForward(containerUrl, true);
        }
        if (StringUtils.isEmpty((String)key)) {
            return ActionHelper.sendError(mapping, request, response, "errors.required", validationKeyMessage);
        }
        try {
            Member member;
            try {
                member = this.elementService.publicValidateRegistration(key);
            }
            catch (EntityNotFoundException e) {
                return ActionHelper.sendError(mapping, request, response, "errors.invalid", validationKeyMessage);
            }
            catch (RegistrationAgreementNotAcceptedException e) {
                return ActionHelper.redirectWithParam(request, mapping.findForward("acceptAgreement"), "key", key);
            }
            String loginParamName = null;
            Long loginParamValue = null;
            MemberGroup group = member.getMemberGroup();
            if (StringUtils.isNotEmpty((String)group.getLoginPageName())) {
                loginParamName = "groupId";
                loginParamValue = group.getId();
            } else {
                for (GroupFilter filter : group.getGroupFilters()) {
                    if (filter.getLoginPageName() == null) continue;
                    loginParamName = "groupFilterId";
                    loginParamValue = filter.getId();
                    break;
                }
            }
            if (loginParamName != null) {
                session.setAttribute("loginParamName", (Object)loginParamName);
                session.setAttribute("loginParamValue", (Object)loginParamValue);
            }
            boolean passwordGenerated = member.getMemberUser().isPasswordGenerated();
            String messageKey = !member.isActive() ? "createMember.public.awaitingActivation" : (passwordGenerated ? "createMember.public.awaitingPassword" : "createMember.public.validated");
            ActionHelper.sendError(mapping, request, response, messageKey, member.getUsername());
            return mapping.findForward("confirmation");
        }
        catch (ValidationException e) {
            return ActionHelper.handleValidationException(mapping, request, response, e);
        }
        catch (Exception e) {
            this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
            return ActionHelper.sendError(mapping, request, response, null, new Object[0]);
        }
    }

    private String findContainerUrl(final PendingMember pendingMember) {
        return LoggedUser.runAsSystem(new Callable<String>(){

            @Override
            public String call() throws Exception {
                MemberGroup group = pendingMember.getMemberGroup();
                CustomizationHelper.CustomizationData customization = ValidateRegistrationAction.this.customizationHelper.findCustomizationOf(CustomizedFile.Type.STATIC_FILE, group, null, "login.jsp");
                switch (customization.getLevel()) {
                    case GROUP: {
                        return group.getContainerUrl();
                    }
                    case GROUP_FILTER: {
                        GroupFilter groupFilter = ValidateRegistrationAction.this.groupFilterService.load(customization.getId(), new Relationship[0]);
                        return groupFilter.getContainerUrl();
                    }
                }
                LocalSettings localSettings = ValidateRegistrationAction.this.settingsService.getLocalSettings();
                return localSettings.getContainerUrl();
            }
        });
    }
}

