/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.preferences.NotificationPreferenceForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.members.preferences.NotificationPreference;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.sms.MemberSmsStatus;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.elements.MemberService;
import nl.strohalm.cyclos.services.preferences.PreferenceService;
import nl.strohalm.cyclos.services.sms.ISmsContext;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class NotificationPreferenceAction
extends BaseFormAction {
    private PreferenceService preferenceService;
    private ChannelService channelService;
    private MemberService memberService;

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setMemberService(MemberService memberService) {
        this.memberService = memberService;
    }

    @Inject
    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        Member member;
        Collection<NotificationPreference> list;
        NotificationPreferenceForm form = (NotificationPreferenceForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        if (memberId < 1L) {
            memberId = ((Entity)context.getElement()).getId();
        }
        if ((list = this.preferenceService.load(member = (Member)this.elementService.load(memberId, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.SMS_MESSAGES), Member.Relationships.CHANNELS))) == null) {
            list = new ArrayList<NotificationPreference>();
        }
        HashMap<Message.Type, NotificationPreference> map = new HashMap<Message.Type, NotificationPreference>();
        for (NotificationPreference preference : list) {
            map.put(preference.getType(), preference);
        }
        boolean hasEmail = StringUtils.isNotEmpty((String)member.getEmail());
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        boolean smsEnabled = localSettings.isSmsEnabled();
        boolean hasNotificationsBySms = false;
        List<Message.Type> usedTypes = this.preferenceService.listNotificationTypes(member);
        for (Message.Type type : Message.Type.values()) {
            String isEmailStr = (String)form.getNotificationPreference(type.name() + "_email");
            String isMessageStr = (String)form.getNotificationPreference(type.name() + "_message");
            String isSmsStr = (String)form.getNotificationPreference(type.name() + "_sms");
            boolean isEmail = false;
            boolean isMessage = false;
            boolean isSms = false;
            if (usedTypes.contains(type)) {
                isEmail = hasEmail ? CoercionHelper.coerce(Boolean.TYPE, isEmailStr) : false;
                isMessage = CoercionHelper.coerce(Boolean.TYPE, isMessageStr);
                if (type == Message.Type.FROM_ADMIN_TO_MEMBER || type == Message.Type.FROM_ADMIN_TO_GROUP) {
                    isMessage = true;
                }
                if (smsEnabled) {
                    isSms = CoercionHelper.coerce(Boolean.TYPE, isSmsStr);
                }
            }
            hasNotificationsBySms |= isSms;
            NotificationPreference preference = (NotificationPreference)map.get(type);
            if (preference == null && (isEmail || isMessage || isSms)) {
                preference = new NotificationPreference();
                preference.setType(type);
                preference.setEmail(isEmail);
                preference.setMessage(isMessage);
                preference.setSms(isSms);
                map.put(type, preference);
                continue;
            }
            if (preference == null) continue;
            preference.setEmail(isEmail);
            preference.setMessage(isMessage);
            preference.setSms(isSms);
        }
        this.preferenceService.save(member, map.values());
        if (smsEnabled) {
            Channel smsChannel = this.channelService.getSmsChannel();
            if (this.accessService.canChangeChannelsAccess(member) && smsChannel != null) {
                HashSet<Channel> channels = new HashSet<Channel>(this.accessService.getChannelsEnabledForMember(member));
                if (form.isEnableSmsOperations()) {
                    channels.add(smsChannel);
                } else {
                    channels.remove(smsChannel);
                }
                this.accessService.changeChannelsAccess(member, channels, false);
            }
            this.preferenceService.saveSmsStatusPreferences(member, form.isAcceptFreeMailing(), form.isAcceptPaidMailing(), form.isAllowChargingSms(), hasNotificationsBySms);
        }
        context.sendMessage("notificationPreferences.modified", new Object[0]);
        if (((Entity)context.getElement()).getId() == memberId) {
            return context.getSuccessForward();
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "memberId", memberId);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        NotificationPreferenceForm form = (NotificationPreferenceForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        if (memberId < 1L) {
            memberId = ((Entity)context.getElement()).getId();
        }
        Member member = (Member)this.elementService.load(memberId, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.SMS_MESSAGES), Member.Relationships.CHANNELS);
        request.setAttribute("member", (Object)member);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Collection<Message.Type> smsMessages = member.getMemberGroup().getSmsMessages();
        boolean hasSmsMessages = CollectionUtils.isNotEmpty(smsMessages);
        boolean smsEnabled = localSettings.isSmsEnabled();
        request.setAttribute("smsEnabled", (Object)smsEnabled);
        request.setAttribute("hasSmsMessages", (Object)hasSmsMessages);
        request.setAttribute("smsEnabledTypes", smsMessages);
        Collection<NotificationPreference> list = this.preferenceService.load(member);
        if (list == null) {
            list = new ArrayList<NotificationPreference>();
        }
        HashMap<Message.Type, NotificationPreference> map = new HashMap<Message.Type, NotificationPreference>();
        for (NotificationPreference preference : list) {
            map.put(preference.getType(), preference);
        }
        boolean hasEmail = StringUtils.isNotEmpty((String)member.getEmail());
        request.setAttribute("hasEmail", (Object)hasEmail);
        List<Message.Type> types = this.preferenceService.listNotificationTypes(member);
        for (Message.Type type : types) {
            boolean isMessage;
            NotificationPreference preference = (NotificationPreference)map.get(type);
            String typeMessage = type.name() + "_message";
            String typeEmail = type.name() + "_email";
            String typeSms = type.name() + "_sms";
            boolean isEmail = preference != null ? preference.isEmail() : false;
            boolean bl = isMessage = preference != null ? preference.isMessage() : false;
            if (type == Message.Type.FROM_ADMIN_TO_MEMBER || type == Message.Type.FROM_ADMIN_TO_GROUP) {
                isMessage = true;
            }
            boolean isSms = preference != null ? preference.isSms() : false;
            form.setNotificationPreference(typeMessage, isMessage);
            form.setNotificationPreference(typeEmail, isEmail);
            form.setNotificationPreference(typeSms, isSms);
        }
        request.setAttribute("types", types);
        if (smsEnabled) {
            ISmsContext smsContext = this.memberService.getSmsContext(member);
            request.setAttribute("maxFreeSms", (Object)smsContext.getFreeSms(member));
            request.setAttribute("additionalChargedSms", (Object)smsContext.getAdditionalChargedSms(member));
            request.setAttribute("additionalChargeAmount", (Object)smsContext.getAdditionalChargeAmount(member));
            TransferType tt = member.getMemberGroup().getMemberSettings().getSmsChargeTransferType();
            request.setAttribute("additionalChargeCurrency", (Object)(tt == null ? null : tt.getCurrency()));
            request.setAttribute("additionalChargePeriod", (Object)smsContext.getAdditionalChargedPeriod(member));
            MemberSmsStatus smsStatus = this.preferenceService.getMemberSmsStatus(member);
            request.setAttribute("showFreeSms", (Object)smsContext.showFreeSms(smsStatus));
            Channel smsChannel = this.channelService.getSmsChannel();
            if (smsChannel != null) {
                boolean hasAccessToSmsChannel = member.getMemberGroup().getChannels().contains(smsChannel);
                form.setEnableSmsOperations(this.accessService.isChannelEnabledForMember(smsChannel.getInternalName(), member));
                request.setAttribute("hasAccessToSmsChannel", (Object)hasAccessToSmsChannel);
                if (hasAccessToSmsChannel) {
                    request.setAttribute("canChangeChannelAccess", (Object)this.accessService.canChangeChannelsAccess(member));
                }
            }
            form.setAllowChargingSms(smsStatus.isAllowChargingSms());
            form.setAcceptFreeMailing(smsStatus.isAcceptFreeMailing());
            form.setAcceptPaidMailing(smsStatus.isAcceptPaidMailing());
            request.setAttribute("smsStatus", (Object)smsStatus);
        }
    }
}

