/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.records;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.records.EditMemberRecordForm;
import nl.strohalm.cyclos.controls.members.records.SearchMemberRecordsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.Navigation;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditMemberRecordAction
extends BaseFormAction {
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private MemberRecordService memberRecordService;
    private MemberRecordTypeService memberRecordTypeService;
    private DataBinder<MemberRecord> dataBinder;
    private CustomFieldHelper customFieldHelper;

    public MemberRecordService getMemberRecordService() {
        return this.memberRecordService;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setMemberRecordService(MemberRecordService memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    @Inject
    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditMemberRecordForm form = (EditMemberRecordForm)((Object)context.getForm());
        MemberRecord memberRecord = this.getDataBinder().readFromString(form.getMemberRecord());
        boolean isInsert = memberRecord.isTransient();
        memberRecord = isInsert ? this.memberRecordService.insert(memberRecord) : this.memberRecordService.update(memberRecord);
        if (isInsert) {
            context.sendMessage("memberRecord.inserted", new Object[0]);
        } else {
            context.sendMessage("memberRecord.modified", new Object[0]);
        }
        boolean isFlat = memberRecord.getType().getLayout() == MemberRecordType.Layout.FLAT;
        Navigation navigation = context.getNavigation();
        String last = navigation.getPrevious();
        ActionForward forward = last != null && last.contains("/search") ? context.findForward("successList") : (isFlat ? context.findForward("successFlat") : context.getSuccessForward());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberRecordId", memberRecord.getId());
        SearchMemberRecordsForm searchForm = (SearchMemberRecordsForm)((Object)context.getSession().getAttribute("searchMemberRecordsForm"));
        if (searchForm == null || !searchForm.isGlobal()) {
            params.put("elementId", memberRecord.getElement().getId());
        }
        params.put("typeId", memberRecord.getType().getId());
        forward = ActionHelper.redirectWithParams(context.getRequest(), forward, params);
        if (isFlat) {
            forward.setPath(forward.getPath() + "#memberRecord_" + memberRecord.getId());
        }
        return forward;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberRecord memberRecord;
        boolean isInsert;
        HttpServletRequest request = context.getRequest();
        EditMemberRecordForm form = (EditMemberRecordForm)((Object)context.getForm());
        MemberRecordType type = null;
        Element element = null;
        long memberRecordId = form.getMemberRecordId();
        boolean bl = isInsert = memberRecordId <= 0L;
        if (isInsert) {
            request.setAttribute("isInsert", (Object)true);
            memberRecord = new MemberRecord();
            long baseMemberRecordId = form.getBaseMemberRecordId();
            if (baseMemberRecordId > 0L) {
                MemberRecord baseMemberRecord = this.memberRecordService.load(baseMemberRecordId, MemberRecord.Relationships.TYPE, MemberRecord.Relationships.ELEMENT, MemberRecord.Relationships.CUSTOM_VALUES);
                type = baseMemberRecord.getType();
                element = baseMemberRecord.getElement();
                this.customFieldHelper.cloneFieldValues(baseMemberRecord, memberRecord);
                request.setAttribute("baseMemberRecord", (Object)baseMemberRecord);
            }
            memberRecord.setType(type);
            memberRecord.setElement(element);
        } else {
            memberRecord = this.memberRecordService.load(memberRecordId, MemberRecord.Relationships.BY, MemberRecord.Relationships.MODIFIED_BY, MemberRecord.Relationships.CUSTOM_VALUES, MemberRecord.Relationships.ELEMENT);
            type = memberRecord.getType();
            element = memberRecord.getElement();
            request.setAttribute("memberRecord", (Object)memberRecord);
        }
        if (type == null) {
            long typeId = form.getTypeId();
            if (typeId <= 0L) {
                throw new ValidationException();
            }
            type = this.memberRecordTypeService.load(typeId, new Relationship[0]);
        }
        if (element == null) {
            long elementId = form.getElementId();
            if (elementId <= 0L) {
                throw new ValidationException();
            }
            element = this.elementService.load(elementId, new Relationship[0]);
        }
        boolean byBroker = element instanceof Member && context.isBrokerOf((Member)element);
        request.setAttribute("element", (Object)element);
        request.setAttribute("byBroker", (Object)byBroker);
        request.setAttribute("type", (Object)type);
        request.setAttribute("global", (Object)form.isGlobal());
        List<MemberRecordCustomField> customFields = this.memberRecordCustomFieldService.list(type);
        if (byBroker) {
            HashSet<MemberRecordCustomField> readOnlyFields = new HashSet<MemberRecordCustomField>();
            Iterator<MemberRecordCustomField> iterator = customFields.iterator();
            while (iterator.hasNext()) {
                MemberRecordCustomField field = iterator.next();
                switch (field.getBrokerAccess()) {
                    case NONE: {
                        iterator.remove();
                        break;
                    }
                    case READ_ONLY: {
                        if (isInsert) {
                            iterator.remove();
                            break;
                        }
                        readOnlyFields.add(field);
                    }
                }
            }
            request.setAttribute("readOnlyFields", readOnlyFields);
        }
        request.setAttribute("customFields", customFields);
        Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, memberRecord.getCustomValues());
        request.setAttribute("customFieldEntries", entries);
        Object group = context.getGroup();
        boolean canCreate = false;
        boolean canModify = false;
        boolean canDelete = false;
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)group;
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.CREATE_MEMBER_RECORD_TYPES, AdminGroup.Relationships.MODIFY_MEMBER_RECORD_TYPES, AdminGroup.Relationships.DELETE_MEMBER_RECORD_TYPES, AdminGroup.Relationships.CREATE_ADMIN_RECORD_TYPES, AdminGroup.Relationships.MODIFY_ADMIN_RECORD_TYPES, AdminGroup.Relationships.DELETE_ADMIN_RECORD_TYPES);
            if (element instanceof Member) {
                canCreate = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_CREATE) && adminGroup.getCreateMemberRecordTypes().contains(type);
                canModify = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_MODIFY) && adminGroup.getModifyMemberRecordTypes().contains(type);
                canDelete = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_DELETE) && adminGroup.getDeleteMemberRecordTypes().contains(type);
            } else if (element instanceof Administrator) {
                canCreate = this.permissionService.hasPermission(AdminAdminPermission.RECORDS_CREATE) && adminGroup.getCreateAdminRecordTypes().contains(type);
                canModify = this.permissionService.hasPermission(AdminAdminPermission.RECORDS_MODIFY) && adminGroup.getModifyAdminRecordTypes().contains(type);
                canDelete = this.permissionService.hasPermission(AdminAdminPermission.RECORDS_DELETE) && adminGroup.getDeleteAdminRecordTypes().contains(type);
            }
        } else if (element instanceof Member && context.isBrokerOf((Member)element)) {
            BrokerGroup brokerGroup = (BrokerGroup)group;
            brokerGroup = (BrokerGroup)this.groupService.load(brokerGroup.getId(), BrokerGroup.Relationships.BROKER_CREATE_MEMBER_RECORD_TYPES, BrokerGroup.Relationships.BROKER_MODIFY_MEMBER_RECORD_TYPES);
            canCreate = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_CREATE) && brokerGroup.getBrokerCreateMemberRecordTypes().contains(type);
            canModify = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_MODIFY) && brokerGroup.getBrokerModifyMemberRecordTypes().contains(type);
            canDelete = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_DELETE) && brokerGroup.getBrokerDeleteMemberRecordTypes().contains(type);
        }
        request.setAttribute("canCreate", (Object)canCreate);
        request.setAttribute("canModify", (Object)canModify);
        request.setAttribute("canDelete", (Object)canDelete);
    }

    private DataBinder<MemberRecord> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberRecordCustomFieldValue> customValueBinder = BeanBinder.instance(MemberRecordCustomFieldValue.class);
            customValueBinder.registerBinder("field", PropertyBinder.instance(MemberRecordCustomField.class, "field"));
            customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
            BeanBinder<MemberRecord> binder = BeanBinder.instance(MemberRecord.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("type", PropertyBinder.instance(MemberRecordType.class, "type"));
            binder.registerBinder("element", PropertyBinder.instance(Element.class, "element"));
            binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

