/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.records;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.records.EditMemberRecordTypeForm;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.struts.action.ActionForward;

public class EditMemberRecordTypeAction
extends BaseFormAction {
    private MemberRecordTypeService memberRecordTypeService;
    private DataBinder<MemberRecordType> dataBinder;

    @Inject
    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditMemberRecordTypeForm form = (EditMemberRecordTypeForm)((Object)context.getForm());
        MemberRecordType memberRecordType = this.getDataBinder().readFromString(form.getMemberRecordType());
        boolean isInsert = memberRecordType.isTransient();
        memberRecordType = this.memberRecordTypeService.save(memberRecordType);
        if (isInsert) {
            context.sendMessage("memberRecordType.inserted", new Object[0]);
        } else {
            context.sendMessage("memberRecordType.modified", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "memberRecordTypeId", memberRecordType.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        MemberRecordType memberRecordType;
        HttpServletRequest request = context.getRequest();
        EditMemberRecordTypeForm form = (EditMemberRecordTypeForm)((Object)context.getForm());
        long id = form.getMemberRecordTypeId();
        boolean isInsert = id <= 0L;
        boolean editable = this.permissionService.hasPermission(AdminSystemPermission.MEMBER_RECORD_TYPES_MANAGE);
        if (isInsert) {
            memberRecordType = new MemberRecordType();
            editable = true;
        } else {
            memberRecordType = this.memberRecordTypeService.load(id, MemberRecordType.Relationships.FIELDS, MemberRecordType.Relationships.GROUPS);
        }
        this.getDataBinder().writeAsString(form.getMemberRecordType(), memberRecordType);
        request.setAttribute("memberRecordType", (Object)memberRecordType);
        request.setAttribute("editable", (Object)editable);
        request.setAttribute("isInsert", (Object)isInsert);
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER, Group.Nature.ADMIN);
        groupQuery.setStatus(Group.Status.NORMAL);
        List<? extends Group> groups = this.groupService.search(groupQuery);
        request.setAttribute("groups", groups);
        RequestHelper.storeEnum(request, MemberRecordType.Layout.class, "layouts");
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditMemberRecordTypeForm form = (EditMemberRecordTypeForm)((Object)context.getForm());
        MemberRecordType memberRecordType = this.getDataBinder().readFromString(form.getMemberRecordType());
        this.memberRecordTypeService.validate(memberRecordType);
    }

    private DataBinder<MemberRecordType> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<MemberRecordType> binder = BeanBinder.instance(MemberRecordType.class);
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("name", PropertyBinder.instance(String.class, "name"));
            binder.registerBinder("label", PropertyBinder.instance(String.class, "label"));
            binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
            binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
            binder.registerBinder("layout", PropertyBinder.instance(MemberRecordType.Layout.class, "layout"));
            binder.registerBinder("editable", PropertyBinder.instance(Boolean.TYPE, "editable"));
            binder.registerBinder("showMenuItem", PropertyBinder.instance(Boolean.TYPE, "showMenuItem"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

