/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.records;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseCsvAction;
import nl.strohalm.cyclos.controls.members.records.SearchMemberRecordsAction;
import nl.strohalm.cyclos.controls.members.records.SearchMemberRecordsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.FullTextMemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.conversion.CustomFieldConverter;
import nl.strohalm.cyclos.utils.conversion.FormatOnlyConverter;
import nl.strohalm.cyclos.utils.csv.CSVWriter;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class ExportMemberRecordsToCsvAction
extends BaseCsvAction {
    private MemberRecordTypeService memberRecordTypeService;
    private MemberRecordService memberRecordService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private DataBinder<FullTextMemberRecordQuery> dataBinder;

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setMemberRecordService(MemberRecordService memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    @Inject
    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    protected List<?> executeQuery(ActionContext context) {
        SearchMemberRecordsForm form = (SearchMemberRecordsForm)((Object)context.getForm());
        FullTextMemberRecordQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.fetch(RelationshipHelper.nested(MemberRecord.Relationships.BY, Element.Relationships.USER));
        query.fetch(MemberRecord.Relationships.CUSTOM_VALUES);
        query.fetch(RelationshipHelper.nested(MemberRecord.Relationships.ELEMENT, Element.Relationships.USER));
        query.fetch(RelationshipHelper.nested(MemberRecord.Relationships.ELEMENT, Member.Relationships.BROKER, Element.Relationships.USER));
        query.fetch(RelationshipHelper.nested(MemberRecord.Relationships.MODIFIED_BY, Element.Relationships.USER));
        query.setType(this.resolveType(context));
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.fetch(MemberRecord.Relationships.ELEMENT, MemberRecord.Relationships.CUSTOM_VALUES);
        boolean global = form.isGlobal();
        Element element = null;
        if (!global) {
            long elementId = form.getElementId();
            if (elementId <= 0L) {
                throw new ValidationException();
            }
            element = (Element)this.elementService.load(elementId, Element.Relationships.GROUP);
        }
        if (global) {
            if (form.getQueryElementId() > 0L) {
                Object queryElement = this.elementService.load(form.getQueryElementId(), new Relationship[0]);
                query.setElement((Element)queryElement);
            }
        } else {
            query.setElement(element);
        }
        return this.memberRecordService.fullTextSearch(query);
    }

    @Override
    protected String fileName(ActionContext context) {
        Object loggedUser = context.getUser();
        MemberRecordType type = this.resolveType(context);
        return type.getLabel() + "_" + ((User)loggedUser).getUsername() + ".csv";
    }

    protected CSVWriter resolveCSVWriter(ActionContext context) {
        MemberRecordType type = this.resolveType(context);
        LocalSettings settings = this.settingsService.getLocalSettings();
        CSVWriter<MemberRecord> csv = CSVWriter.instance(MemberRecord.class, settings);
        csv.addColumn(context.message("memberRecord.date", new Object[0]), "date", settings.getDateTimeConverter());
        csv.addColumn(context.message("memberRecord.by", new Object[0]), "by.name");
        if (type.isEditable()) {
            csv.addColumn(context.message("memberRecord.lastModified", new Object[0]), "lastModified", settings.getDateTimeConverter());
            csv.addColumn(context.message("memberRecord.modifiedBy", new Object[0]), "modifiedBy.name");
        }
        csv.addColumn(context.message("member.username", new Object[0]), "element.username");
        csv.addColumn(context.message("member.name", new Object[0]), "element.name");
        csv.addColumn(context.message("member.brokerUsername", new Object[0]), "element", new BrokerConverter(true));
        csv.addColumn(context.message("member.brokerName", new Object[0]), "element", new BrokerConverter(false));
        List<MemberRecordCustomField> customFields = this.memberRecordCustomFieldService.list(type);
        for (MemberRecordCustomField field : customFields) {
            csv.addColumn(field.getName(), "customValues", new CustomFieldConverter(field, this.elementService, settings));
        }
        return csv;
    }

    private DataBinder<FullTextMemberRecordQuery> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = SearchMemberRecordsAction.memberRecordQueryDataBinder(this.settingsService.getLocalSettings());
        }
        return this.dataBinder;
    }

    private MemberRecordType resolveType(ActionContext context) {
        SearchMemberRecordsForm form = (SearchMemberRecordsForm)((Object)context.getForm());
        long typeId = form.getTypeId();
        if (typeId <= 0L) {
            throw new ValidationException();
        }
        return this.memberRecordTypeService.load(typeId, new Relationship[0]);
    }

    private static class BrokerConverter
    extends FormatOnlyConverter<Element> {
        private static final long serialVersionUID = 1L;
        private final boolean username;

        public BrokerConverter(boolean username) {
            this.username = username;
        }

        @Override
        public String toString(Element element) {
            Member broker;
            if (element instanceof Member && (broker = ((Member)element).getBroker()) != null) {
                return this.username ? broker.getUsername() : broker.getName();
            }
            return null;
        }
    }
}

