/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.records;

import java.util.HashMap;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.members.records.RemoveMemberRecordForm;
import nl.strohalm.cyclos.controls.members.records.SearchMemberRecordsForm;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class RemoveMemberRecordAction
extends BaseAction {
    private MemberRecordService memberRecordService;

    @Inject
    public void setMemberRecordService(MemberRecordService memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        ActionForward forward;
        boolean isFlat;
        RemoveMemberRecordForm form = (RemoveMemberRecordForm)((Object)context.getForm());
        long id = form.getMemberRecordId();
        if (id <= 0L) {
            throw new ValidationException();
        }
        MemberRecord record = this.memberRecordService.load(id, MemberRecord.Relationships.ELEMENT, MemberRecord.Relationships.TYPE);
        MemberRecordType type = record.getType();
        String typeName = type.getName();
        try {
            this.memberRecordService.remove(id);
            context.sendMessage("memberRecord.removed", typeName);
        }
        catch (PermissionDeniedException e) {
            throw e;
        }
        catch (Exception e) {
            return context.sendError("memberRecord.error.removing", typeName);
        }
        boolean isGlobal = false;
        SearchMemberRecordsForm searchForm = (SearchMemberRecordsForm)((Object)context.getSession().getAttribute("searchMemberRecordsForm"));
        if (searchForm != null && searchForm.isGlobal()) {
            isGlobal = true;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean bl = isFlat = record.getType().getLayout() == MemberRecordType.Layout.FLAT;
        if (isGlobal) {
            forward = context.getSuccessForward();
        } else {
            forward = isFlat ? context.findForward("successFlat") : context.getSuccessForward();
            params.put("elementId", record.getElement().getId());
            params.put("typeId", type.getId());
        }
        return ActionHelper.redirectWithParams(context.getRequest(), forward, params);
    }
}

