/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.records;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.records.SearchMemberRecordsForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.records.FullTextMemberRecordQuery;
import nl.strohalm.cyclos.entities.members.records.MemberRecord;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.elements.MemberRecordService;
import nl.strohalm.cyclos.services.elements.MemberRecordTypeService;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchMemberRecordsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<FullTextMemberRecordQuery> dataBinder;
    private MemberRecordService memberRecordService;
    private MemberRecordTypeService memberRecordTypeService;
    private MemberRecordCustomFieldService memberRecordCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    public static BeanBinder<FullTextMemberRecordQuery> memberRecordQueryDataBinder(LocalSettings localSettings) {
        BeanBinder<MemberRecordCustomFieldValue> customValuesBinder = BeanBinder.instance(MemberRecordCustomFieldValue.class);
        customValuesBinder.registerBinder("field", PropertyBinder.instance(MemberRecordCustomField.class, "field"));
        customValuesBinder.registerBinder("value", PropertyBinder.instance(String.class, "value"));
        BeanBinder<FullTextMemberRecordQuery> binder = BeanBinder.instance(FullTextMemberRecordQuery.class);
        binder.registerBinder("element", PropertyBinder.instance(Element.class, "element"));
        binder.registerBinder("broker", PropertyBinder.instance(Member.class, "broker"));
        binder.registerBinder("period", DataBinderHelper.periodBinder(localSettings, "period"));
        binder.registerBinder("keywords", PropertyBinder.instance(String.class, "keywords"));
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValuesBinder, "customValues"));
        binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
        return binder;
    }

    public DataBinder<FullTextMemberRecordQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            this.dataBinder = SearchMemberRecordsAction.memberRecordQueryDataBinder(localSettings);
        }
        return this.dataBinder;
    }

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setMemberRecordCustomFieldService(MemberRecordCustomFieldService memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Inject
    public void setMemberRecordService(MemberRecordService memberRecordService) {
        this.memberRecordService = memberRecordService;
    }

    @Inject
    public void setMemberRecordTypeService(MemberRecordTypeService memberRecordTypeService) {
        this.memberRecordTypeService = memberRecordTypeService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        FullTextMemberRecordQuery query = (FullTextMemberRecordQuery)queryParameters;
        List<MemberRecord> memberRecords = this.memberRecordService.fullTextSearch(query);
        request.setAttribute("memberRecords", memberRecords);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchMemberRecordsForm form = (SearchMemberRecordsForm)((Object)context.getForm());
        long typeId = form.getTypeId();
        if (typeId <= 0L) {
            throw new ValidationException();
        }
        MemberRecordType type = this.memberRecordTypeService.load(typeId, new Relationship[0]);
        request.setAttribute("type", (Object)type);
        boolean global = form.isGlobal();
        Element element = null;
        if (!global) {
            long elementId = form.getElementId();
            if (elementId <= 0L) {
                throw new ValidationException();
            }
            element = (Element)this.elementService.load(elementId, Element.Relationships.GROUP);
        }
        request.setAttribute("element", element);
        FullTextMemberRecordQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setType(type);
        if (global) {
            if (form.getQueryElementId() > 0L) {
                Object queryElement = this.elementService.load(form.getQueryElementId(), new Relationship[0]);
                query.setElement((Element)queryElement);
            }
            if (context.isBroker()) {
                query.setBroker(context.getMember());
            } else if (context.isAdmin() && query.getBroker() != null) {
                Member broker = (Member)this.elementService.load(query.getBroker().getId(), new Relationship[0]);
                query.setBroker(broker);
            }
        } else {
            query.setElement(element);
        }
        query.fetch(MemberRecord.Relationships.TYPE);
        List<MemberRecordCustomField> customFields = this.memberRecordCustomFieldService.list(type);
        ArrayList<MemberRecordCustomField> fieldsForSearch = new ArrayList<MemberRecordCustomField>();
        ArrayList<MemberRecordCustomField> fieldsOnList = new ArrayList<MemberRecordCustomField>();
        for (MemberRecordCustomField field : customFields) {
            if (field.isShowInSearch()) {
                fieldsForSearch.add(field);
            }
            if (!field.isShowInList()) continue;
            fieldsOnList.add(field);
        }
        request.setAttribute("customValues", this.customFieldHelper.buildEntries(fieldsForSearch, query.getCustomValues()));
        request.setAttribute("fieldsOnList", fieldsOnList);
        Object group = context.getGroup();
        boolean canCreate = false;
        boolean canModify = false;
        boolean canDelete = false;
        if (context.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)group;
            adminGroup = (AdminGroup)this.groupService.load(adminGroup.getId(), AdminGroup.Relationships.CREATE_MEMBER_RECORD_TYPES, AdminGroup.Relationships.MODIFY_MEMBER_RECORD_TYPES, AdminGroup.Relationships.DELETE_MEMBER_RECORD_TYPES, AdminGroup.Relationships.CREATE_ADMIN_RECORD_TYPES, AdminGroup.Relationships.MODIFY_ADMIN_RECORD_TYPES, AdminGroup.Relationships.DELETE_ADMIN_RECORD_TYPES);
            if (global) {
                canCreate = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_CREATE) && adminGroup.getCreateMemberRecordTypes().contains(type) || this.permissionService.hasPermission(AdminAdminPermission.RECORDS_CREATE) && adminGroup.getCreateAdminRecordTypes().contains(type);
                canModify = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_MODIFY) && adminGroup.getModifyMemberRecordTypes().contains(type) || this.permissionService.hasPermission(AdminAdminPermission.RECORDS_MODIFY) && adminGroup.getModifyAdminRecordTypes().contains(type);
                canDelete = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_DELETE) && adminGroup.getDeleteMemberRecordTypes().contains(type) || this.permissionService.hasPermission(AdminAdminPermission.RECORDS_DELETE) && adminGroup.getDeleteAdminRecordTypes().contains(type);
            } else if (element instanceof Member) {
                canCreate = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_CREATE) && adminGroup.getCreateMemberRecordTypes().contains(type);
                canModify = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_MODIFY) && adminGroup.getModifyMemberRecordTypes().contains(type);
                canDelete = this.permissionService.hasPermission(AdminMemberPermission.RECORDS_DELETE) && adminGroup.getDeleteMemberRecordTypes().contains(type);
            } else if (element instanceof Administrator) {
                canCreate = this.permissionService.hasPermission(AdminAdminPermission.RECORDS_CREATE) && adminGroup.getCreateAdminRecordTypes().contains(type);
                canModify = this.permissionService.hasPermission(AdminAdminPermission.RECORDS_MODIFY) && adminGroup.getModifyAdminRecordTypes().contains(type);
                canDelete = this.permissionService.hasPermission(AdminAdminPermission.RECORDS_DELETE) && adminGroup.getDeleteAdminRecordTypes().contains(type);
            }
        } else if (element instanceof Member && context.isBrokerOf((Member)element)) {
            BrokerGroup brokerGroup = (BrokerGroup)group;
            brokerGroup = (BrokerGroup)this.groupService.load(brokerGroup.getId(), BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES, BrokerGroup.Relationships.BROKER_CREATE_MEMBER_RECORD_TYPES, BrokerGroup.Relationships.BROKER_MODIFY_MEMBER_RECORD_TYPES, BrokerGroup.Relationships.BROKER_DELETE_MEMBER_RECORD_TYPES);
            canCreate = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_CREATE) && brokerGroup.getBrokerCreateMemberRecordTypes().contains(type);
            canModify = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_MODIFY) && brokerGroup.getBrokerModifyMemberRecordTypes().contains(type);
            canDelete = this.permissionService.hasPermission(BrokerPermission.MEMBER_RECORDS_DELETE) && brokerGroup.getBrokerDeleteMemberRecordTypes().contains(type);
        }
        request.setAttribute("canCreate", (Object)canCreate);
        request.setAttribute("canModify", (Object)canModify);
        request.setAttribute("canDelete", (Object)canDelete);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        SearchMemberRecordsForm form = (SearchMemberRecordsForm)((Object)context.getForm());
        if (form.isGlobal()) {
            return !RequestHelper.isFromMenu(context.getRequest());
        }
        return true;
    }
}

