/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.references;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.members.references.BaseEditReferenceAction;
import nl.strohalm.cyclos.controls.members.references.EditReferenceForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.GeneralReference;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class EditGeneralReferenceAction
extends BaseEditReferenceAction<GeneralReference> {
    private DataBinder<GeneralReference> dataBinder;

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        GeneralReference reference = this.resolveReference(context);
        boolean isInsert = reference.isTransient();
        GeneralReference generalReference = reference;
        reference = this.referenceService.save(generalReference);
        context.sendMessage("reference." + (isInsert ? "inserted" : "modified"), new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "referenceId", reference.getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        GeneralReference reference;
        EditReferenceForm form = (EditReferenceForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long referenceId = form.getReferenceId();
        AccountOwner accountOwner = context.getAccountOwner();
        if (referenceId > 0L) {
            if (form.getMemberId() == 0L && accountOwner instanceof Member) {
                form.setMemberId(((Member)accountOwner).getId());
            }
            reference = (GeneralReference)this.referenceService.load(referenceId, Reference.Relationships.FROM, Reference.Relationships.TO);
        } else {
            Member member;
            if (form.getMemberId() <= 0L) {
                throw new ValidationException();
            }
            Member loggedMember = (Member)accountOwner;
            try {
                member = (Member)this.elementService.load(form.getMemberId(), new Relationship[0]);
            }
            catch (Exception e) {
                throw new ValidationException();
            }
            try {
                reference = this.referenceService.loadGeneral(loggedMember, member, new Relationship[0]);
            }
            catch (EntityNotFoundException e) {
                reference = new GeneralReference();
                reference.setFrom(loggedMember);
                reference.setTo(member);
            }
        }
        this.getDataBinder().writeAsString(form.getReference(), reference);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        boolean editable = this.referenceService.canManage(reference);
        if (reference.isTransient() && !editable) {
            throw new ValidationException();
        }
        request.setAttribute("reference", (Object)reference);
        request.setAttribute("levels", localSettings.getReferenceLevelList());
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected GeneralReference resolveReference(ActionContext context) {
        EditReferenceForm form = (EditReferenceForm)((Object)context.getForm());
        return this.getDataBinder().readFromString(form.getReference());
    }

    private DataBinder<GeneralReference> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<GeneralReference> binder = BeanBinder.instance(GeneralReference.class);
            this.initBinder(binder);
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

