/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.references;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.members.references.BaseEditReferenceAction;
import nl.strohalm.cyclos.controls.members.references.EditReferenceForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.TransactionFeedbackAction;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class EditTransactionFeedbackAction
extends BaseEditReferenceAction<TransactionFeedback> {
    private DataBinder<TransactionFeedback> dataBinder;

    public DataBinder<TransactionFeedback> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<TransactionFeedback> binder = BeanBinder.instance(TransactionFeedback.class);
            this.initBinder(binder);
            binder.registerBinder("transfer", PropertyBinder.instance(Transfer.class, "transfer"));
            binder.registerBinder("scheduledPayment", PropertyBinder.instance(ScheduledPayment.class, "scheduledPayment"));
            binder.registerBinder("replyComments", PropertyBinder.instance(String.class, "replyComments"));
            binder.registerBinder("adminComments", PropertyBinder.instance(String.class, "adminComments"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditReferenceForm form = (EditReferenceForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        TransactionFeedback feedback = this.resolveReference(context);
        TransactionFeedbackAction tfa = this.referenceService.getPossibleAction(feedback);
        feedback = this.referenceService.save(feedback);
        switch (tfa) {
            case COMMENTS: {
                context.sendMessage("reference.transactionFeedback.saved", new Object[0]);
                break;
            }
            case REPLY_COMMENTS: {
                context.sendMessage("reference.transactionFeedback.replyComments.saved", new Object[0]);
                break;
            }
            case ADMIN_EDIT: {
                context.sendMessage("reference.transactionFeedback.saved", new Object[0]);
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("memberId", memberId);
        params.put("referenceId", feedback.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Payment payment;
        EditReferenceForm form = (EditReferenceForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        long feedbackId = form.getReferenceId();
        long transferId = form.getTransferId();
        long scheduledPaymentId = form.getScheduledPaymentId();
        TransactionFeedback transactionFeedback = null;
        boolean showPayment = false;
        boolean canComment = false;
        boolean canReply = false;
        boolean editable = false;
        if (transferId > 0L || scheduledPaymentId > 0L) {
            payment = transferId > 0L ? this.paymentService.load(transferId, RelationshipHelper.nested(Payment.Relationships.FROM, Account.Relationships.TYPE, AccountType.Relationships.CURRENCY), RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER)) : this.scheduledPaymentService.load(scheduledPaymentId, RelationshipHelper.nested(Payment.Relationships.FROM, Account.Relationships.TYPE, AccountType.Relationships.CURRENCY), RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
            try {
                TransactionFeedback feedback = this.referenceService.loadTransactionFeedback(payment, new Relationship[0]);
                feedbackId = feedback.getId();
            }
            catch (EntityNotFoundException e) {
                Member loggedMember = (Member)context.getAccountOwner();
                if (!loggedMember.equals(payment.getFromOwner())) {
                    throw new ValidationException();
                }
                transactionFeedback = new TransactionFeedback();
                transactionFeedback.setPayment(payment);
                transactionFeedback.setFrom(loggedMember);
                transactionFeedback.setTo((Member)payment.getToOwner());
                showPayment = true;
                canComment = true;
            }
        }
        if (feedbackId > 0L) {
            try {
                transactionFeedback = (TransactionFeedback)this.referenceService.load(feedbackId, Reference.Relationships.FROM, Reference.Relationships.TO, RelationshipHelper.nested(TransactionFeedback.Relationships.TRANSFER, Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(TransactionFeedback.Relationships.TRANSFER, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(TransactionFeedback.Relationships.TRANSFER, Payment.Relationships.TYPE), RelationshipHelper.nested(TransactionFeedback.Relationships.SCHEDULED_PAYMENT, Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(TransactionFeedback.Relationships.SCHEDULED_PAYMENT, Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(TransactionFeedback.Relationships.SCHEDULED_PAYMENT, Payment.Relationships.TYPE));
            }
            catch (Exception e) {
                throw new ValidationException();
            }
            payment = transactionFeedback.getPayment();
            if (payment instanceof ScheduledPayment) {
                form.setScheduledPaymentId(payment.getId());
            } else {
                form.setTransferId(payment.getId());
            }
            showPayment = context.isAdmin() || context.getAccountOwner().equals(payment.getFromOwner()) || context.getAccountOwner().equals(payment.getToOwner());
            canReply = !LoggedUser.isAdministrator() && ((Element)LoggedUser.element()).getAccountOwner().equals(transactionFeedback.getTo()) && StringUtils.isEmpty((String)transactionFeedback.getReplyComments()) && this.referenceService.canReplyFeedbackNow(transactionFeedback);
            editable = this.permissionService.hasPermission(AdminMemberPermission.TRANSACTION_FEEDBACKS_MANAGE);
        }
        if (transactionFeedback == null) {
            throw new ValidationException();
        }
        this.getDataBinder().writeAsString(form.getReference(), transactionFeedback);
        if (editable) {
            canComment = true;
            canReply = true;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        request.setAttribute("transactionFeedback", transactionFeedback);
        request.setAttribute("levels", localSettings.getReferenceLevelList());
        request.setAttribute("showPayment", (Object)showPayment);
        request.setAttribute("canComment", (Object)canComment);
        request.setAttribute("canReply", (Object)canReply);
        request.setAttribute("editable", (Object)editable);
    }

    @Override
    protected TransactionFeedback resolveReference(ActionContext context) {
        EditReferenceForm form = (EditReferenceForm)((Object)context.getForm());
        TransactionFeedback feedback = this.getDataBinder().readFromString(form.getReference());
        if (form.getTransferId() > 0L) {
            feedback.setTransfer(EntityHelper.reference(Transfer.class, form.getTransferId()));
        } else if (form.getScheduledPaymentId() > 0L) {
            feedback.setScheduledPayment(EntityHelper.reference(ScheduledPayment.class, form.getScheduledPaymentId()));
        }
        return feedback;
    }

    @Override
    protected void validateForm(ActionContext context) {
        TransactionFeedback transactionFeedback = this.resolveReference(context);
        switch (this.referenceService.getPossibleAction(transactionFeedback)) {
            case COMMENTS: {
                this.referenceService.validate(transactionFeedback);
                break;
            }
            case REPLY_COMMENTS: {
                if (!StringUtils.isEmpty((String)transactionFeedback.getReplyComments())) break;
                throw new ValidationException("replyComments", "reference.replyComments", new RequiredError(new Object[0]));
            }
        }
    }
}

