/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.references;

import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.references.MemberReferencesForm;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.ReferenceQuery;
import nl.strohalm.cyclos.entities.members.TransactionFeedback;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class MemberReferencesAction
extends BaseQueryAction {
    private DataBinder<ReferenceQuery> dataBinder;
    private ReferenceService referenceService;

    @Inject
    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        MemberReferencesForm form = (MemberReferencesForm)((Object)context.getForm());
        Direction direction = CoercionHelper.coerce(Direction.class, form.getDirection());
        Member member = (Member)request.getAttribute("member");
        ReferenceQuery query = (ReferenceQuery)queryParameters;
        if (member != null) {
            form.setMemberId(member.getId());
        }
        Map<Reference.Level, Integer> allTime = this.referenceService.countReferencesByLevel(query.getNature(), member, direction == Direction.RECEIVED);
        request.setAttribute("summaryAllTime", allTime);
        Period period30 = new TimePeriod(30, TimePeriod.Field.DAYS).periodEndingAt(Calendar.getInstance());
        Map<Reference.Level, Integer> last30Days = this.referenceService.countReferencesHistoryByLevel(query.getNature(), member, period30, direction == Direction.RECEIVED);
        request.setAttribute("summaryLast30Days", last30Days);
        int totalAllTime = 0;
        int total30Days = 0;
        int scoreAllTime = 0;
        int score30Days = 0;
        Collection levels = (Collection)request.getAttribute("levels");
        int nonNeutralCountAllTime = 0;
        int positiveCountAllTime = 0;
        int nonNeutralCount30Days = 0;
        int positiveCount30Days = 0;
        for (Reference.Level level : levels) {
            int value = level.getValue();
            int allTimeCount = CoercionHelper.coerce(Integer.TYPE, allTime.get(level));
            int last30DaysCount = CoercionHelper.coerce(Integer.TYPE, last30Days.get(level));
            totalAllTime += allTimeCount;
            total30Days += last30DaysCount;
            scoreAllTime += allTimeCount * value;
            score30Days += last30DaysCount * value;
            if (value == 0) continue;
            nonNeutralCountAllTime += allTimeCount;
            nonNeutralCount30Days += last30DaysCount;
            if (value <= 0) continue;
            positiveCountAllTime += allTimeCount;
            positiveCount30Days += last30DaysCount;
        }
        int percentAllTime = nonNeutralCountAllTime == 0 ? 0 : Math.round((float)positiveCountAllTime / (float)nonNeutralCountAllTime * 100.0f);
        int percentLast30Days = nonNeutralCount30Days == 0 ? 0 : Math.round((float)positiveCount30Days / (float)nonNeutralCount30Days * 100.0f);
        request.setAttribute("totalAllTime", (Object)totalAllTime);
        request.setAttribute("total30Days", (Object)total30Days);
        request.setAttribute("scoreAllTime", (Object)scoreAllTime);
        request.setAttribute("score30Days", (Object)score30Days);
        request.setAttribute("percentAllTime", (Object)percentAllTime);
        request.setAttribute("percent30Days", (Object)percentLast30Days);
        request.setAttribute("references", this.referenceService.search(query));
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        boolean isGeneral;
        boolean isGiven;
        Member member;
        MemberReferencesForm form = (MemberReferencesForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        ReferenceQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setNature(CoercionHelper.coerce(Reference.Nature.class, form.getNature()));
        if (query.getNature() == null) {
            query.setNature(Reference.Nature.GENERAL);
        }
        try {
            member = (Member)(form.getMemberId() <= 0L ? context.getAccountOwner() : this.elementService.load(form.getMemberId(), Element.Relationships.GROUP));
        }
        catch (Exception e) {
            throw new ValidationException();
        }
        boolean myReferences = member.equals(context.getAccountOwner());
        Direction direction = CoercionHelper.coerce(Direction.class, form.getDirection());
        if (direction == null) {
            direction = Direction.RECEIVED;
            form.setDirection(direction.name());
        }
        boolean bl = isGiven = direction == Direction.GIVEN;
        if (isGiven) {
            query.setFrom(member);
        } else {
            query.setTo(member);
        }
        boolean bl2 = isGeneral = query.getNature() == Reference.Nature.GENERAL;
        if (!isGeneral) {
            query.fetch(RelationshipHelper.nested(TransactionFeedback.Relationships.TRANSFER, Payment.Relationships.TYPE, TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY));
        }
        boolean canSetReference = isGeneral && this.referenceService.canGiveGeneralReference(member);
        boolean canManage = isGeneral && (myReferences && isGiven || !myReferences) && this.referenceService.canManageGeneralReference(member);
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        this.getDataBinder().writeAsString(form.getQuery(), query);
        request.setAttribute("member", (Object)member);
        request.setAttribute("canManage", (Object)canManage);
        request.setAttribute("myReferences", (Object)myReferences);
        request.setAttribute("isGiven", (Object)isGiven);
        request.setAttribute("isGeneral", (Object)isGeneral);
        request.setAttribute("levels", localSettings.getReferenceLevelList());
        request.setAttribute("canSetReference", (Object)canSetReference);
        RequestHelper.storeEnum(request, Direction.class, "directions");
        if (!isGeneral) {
            boolean showAmount = context.isAdmin() || context.getAccountOwner().equals(member);
            request.setAttribute("showAmount", (Object)showAmount);
        }
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<ReferenceQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<ReferenceQuery> binder = BeanBinder.instance(ReferenceQuery.class);
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    public static enum Direction {
        RECEIVED,
        GIVEN;

    }
}

