/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.references;

import java.util.List;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.references.SearchPaymentsAwaitingFeedbackForm;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentAwaitingFeedbackDTO;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PaymentsAwaitingFeedbackQuery;
import nl.strohalm.cyclos.services.elements.ReferenceService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchPaymentsAwaitingFeedbackAction
extends BaseQueryAction {
    private DataBinder<PaymentsAwaitingFeedbackQuery> dataBinder;
    private ReferenceService referenceService;

    @Inject
    public void setReferenceService(ReferenceService referenceService) {
        this.referenceService = referenceService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        PaymentsAwaitingFeedbackQuery query = (PaymentsAwaitingFeedbackQuery)queryParameters;
        List<PaymentAwaitingFeedbackDTO> list = this.referenceService.searchPaymentsAwaitingFeedback(query);
        context.getRequest().setAttribute("payments", list);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchPaymentsAwaitingFeedbackForm form = (SearchPaymentsAwaitingFeedbackForm)((Object)context.getForm());
        Member member = (Member)context.getAccountOwner();
        PaymentsAwaitingFeedbackQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setMember(member);
        query.setExpired(false);
        query.fetch(RelationshipHelper.nested(Payment.Relationships.FROM, Account.Relationships.TYPE, AccountType.Relationships.CURRENCY), RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER));
        this.getDataBinder().writeAsString(form.getQuery(), query);
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<PaymentsAwaitingFeedbackQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<PaymentsAwaitingFeedbackQuery> binder = BeanBinder.instance(PaymentsAwaitingFeedbackQuery.class);
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

