/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.sms;

import java.util.HashMap;
import java.util.TreeSet;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.sms.EditInfoTextForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.infotexts.InfoTextService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.SetConverter;
import org.apache.struts.action.ActionForward;

public class EditInfoTextAction
extends BaseFormAction {
    private DataBinder<InfoText> dataBinder;
    private InfoTextService infoTextService;

    @Inject
    public void setInfoTextService(InfoTextService service) {
        this.infoTextService = service;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        EditInfoTextForm form = (EditInfoTextForm)((Object)context.getForm());
        InfoText infoText = this.getDataBinder().readFromString(form.getValues());
        boolean isInsert = infoText.getId() == null;
        this.infoTextService.save(infoText);
        context.sendMessage(isInsert ? "infoText.inserted" : "infoText.modified", new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("infoTextId", infoText.getId());
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        EditInfoTextForm form = (EditInfoTextForm)((Object)context.getForm());
        if (form.getInfoTextId() != null) {
            InfoText infoText = this.infoTextService.load(form.getInfoTextId(), new Relationship[0]);
            context.getRequest().setAttribute("currentInfoText", (Object)infoText);
        }
        context.getRequest().setAttribute("hasManagePermissions", (Object)this.permissionService.hasPermission(AdminSystemPermission.INFO_TEXTS_MANAGE));
    }

    @Override
    protected void validateForm(ActionContext context) {
        EditInfoTextForm form = (EditInfoTextForm)((Object)context.getForm());
        InfoText infoText = this.getDataBinder().readFromString(form.getValues());
        this.infoTextService.validate(infoText);
    }

    private DataBinder<InfoText> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<InfoText> binder = BeanBinder.instance(InfoText.class);
            LocalSettings settings = this.settingsService.getLocalSettings();
            binder.registerBinder("id", PropertyBinder.instance(Long.class, "id", IdConverter.instance()));
            binder.registerBinder("validity", DataBinderHelper.rawPeriodBinder(settings, "validity"));
            binder.registerBinder("aliases", PropertyBinder.instance(TreeSet.class, "aliases", new SetConverter<TreeSet>(TreeSet.class, ",")));
            binder.registerBinder("subject", PropertyBinder.instance(String.class, "subject"));
            binder.registerBinder("body", PropertyBinder.instance(String.class, "body"));
            binder.registerBinder("enabled", PropertyBinder.instance(Boolean.TYPE, "enabled"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

