/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.sms;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.sms.SearchInfoTextsForm;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.infotexts.InfoTextQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.infotexts.InfoTextService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchInfoTextsAction
extends BaseQueryAction {
    private DataBinder<InfoTextQuery> dataBinder;
    private InfoTextService infoTextService;

    @Inject
    public void setInfoTextService(InfoTextService service) {
        this.infoTextService = service;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        HttpServletRequest request = context.getRequest();
        InfoTextQuery query = (InfoTextQuery)queryParameters;
        if (query.getStartIn() != null && query.getStartIn().getBegin() != null && query.getStartIn().getEnd() != null && query.getStartIn().getBegin().after(query.getStartIn().getEnd())) {
            context.sendMessage("errors.periodInvalidBounds", this.settingsService.getLocalSettings().getRawDateConverter().toString(query.getStartIn().getBegin()));
            return;
        }
        if (query.getEndIn() != null && query.getEndIn().getBegin() != null && query.getEndIn().getEnd() != null && query.getEndIn().getBegin().after(query.getEndIn().getEnd())) {
            context.sendMessage("errors.periodInvalidBounds", this.settingsService.getLocalSettings().getRawDateConverter().toString(query.getEndIn().getBegin()));
            return;
        }
        List<InfoText> result = this.infoTextService.search(query);
        request.setAttribute("infoTexts", result);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        SearchInfoTextsForm form = (SearchInfoTextsForm)((Object)context.getForm());
        InfoTextQuery query = this.getDataBinder().readFromString(form.getQuery());
        context.getRequest().setAttribute("hasManagePermissions", (Object)this.permissionService.hasPermission(AdminSystemPermission.INFO_TEXTS_MANAGE));
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<InfoTextQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<InfoTextQuery> binder = BeanBinder.instance(InfoTextQuery.class);
            LocalSettings settings = this.settingsService.getLocalSettings();
            binder.registerBinder("keywords", PropertyBinder.instance(String.class, "keywords"));
            binder.registerBinder("startIn", DataBinderHelper.rawPeriodBinder(settings, "validity"));
            binder.registerBinder("endIn", DataBinderHelper.rawPeriodBinder(settings, "validityEnd"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

