/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.sms;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.sms.SearchSmsLogsForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.entities.sms.SmsLog;
import nl.strohalm.cyclos.entities.sms.SmsLogQuery;
import nl.strohalm.cyclos.entities.sms.SmsLogStatus;
import nl.strohalm.cyclos.entities.sms.SmsLogType;
import nl.strohalm.cyclos.services.sms.SmsLogService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchSmsLogsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<SmsLogQuery> dataBinder;
    private SmsLogService smsLogService;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setSmsLogService(SmsLogService smsLogService) {
        this.smsLogService = smsLogService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        SmsLogQuery query = (SmsLogQuery)queryParameters;
        List<SmsLog> smsLogs = this.smsLogService.search(query);
        HttpServletRequest request = context.getRequest();
        request.setAttribute("smsLogs", smsLogs);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SearchSmsLogsForm form = (SearchSmsLogsForm)((Object)context.getForm());
        long memberId = form.getMemberId();
        if (memberId < 1L) {
            memberId = ((Entity)context.getElement()).getId();
        }
        boolean mySmsLogs = memberId == ((Entity)context.getElement()).getId();
        Member member = (Member)this.elementService.load(memberId, RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.SMS_MESSAGES));
        form.setQuery("member", member.getId());
        request.setAttribute("member", (Object)member);
        request.setAttribute("mySmsLogs", (Object)mySmsLogs);
        RequestHelper.storeEnum(request, SmsLogStatus.class, "statusList");
        RequestHelper.storeEnum(request, SmsLogType.class, "typesList");
        return this.getDataBinder().readFromString(form.getQuery());
    }

    private DataBinder<SmsLogQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            BeanBinder<SmsLogQuery> binder = BeanBinder.instance(SmsLogQuery.class);
            binder.registerBinder("period", DataBinderHelper.periodBinder(settings, "period"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("type", PropertyBinder.instance(SmsLogType.class, "type"));
            binder.registerBinder("status", PropertyBinder.instance(SmsLogStatus.class, "status"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

