/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.sms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.members.sms.SearchSmsMailingVariablesAjaxForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.sms.SmsMailingService;
import org.apache.commons.lang.ArrayUtils;
import org.json.simple.JSONObject;

public class SearchSmsMailingVariablesAjaxAction
extends BaseAjaxAction {
    protected SmsMailingService smsMailingService;

    @Inject
    public final void setSmsMailingService(SmsMailingService smsMailingService) {
        this.smsMailingService = smsMailingService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.JSON;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        boolean isToMember;
        List<MemberGroup> groups = this.resolveGroups(context);
        Map<String, String> variables = null;
        Member m = this.resolveMember(context);
        boolean bl = isToMember = m != null;
        if (groups != null || context.isBroker() && !isToMember) {
            variables = this.smsMailingService.getSmsTextVariables(groups);
        } else if (m != null) {
            variables = this.smsMailingService.getSmsTextVariables(m);
        }
        JSONObject json = new JSONObject();
        ArrayList entries = new ArrayList();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            ArrayList<String> e = new ArrayList<String>();
            e.add(entry.getKey());
            e.add(entry.getValue());
            entries.add(e);
        }
        json.put((Object)"entries", entries);
        this.responseHelper.writeJSON(context.getResponse(), json.toJSONString());
    }

    private List<MemberGroup> resolveGroups(ActionContext context) {
        ArrayList<MemberGroup> groups = null;
        SearchSmsMailingVariablesAjaxForm form = (SearchSmsMailingVariablesAjaxForm)((Object)context.getForm());
        if (ArrayUtils.isNotEmpty((Object[])form.getGroupIds())) {
            groups = new ArrayList<MemberGroup>();
            for (Long id : form.getGroupIds()) {
                if (id <= 0L) continue;
                groups.add((MemberGroup)this.groupService.load(id, new Relationship[0]));
            }
        }
        return groups;
    }

    private Member resolveMember(ActionContext context) {
        SearchSmsMailingVariablesAjaxForm form = (SearchSmsMailingVariablesAjaxForm)((Object)context.getForm());
        Member member = null;
        long memberId = form.getMemberId();
        if (memberId > 0L) {
            try {
                member = (Member)this.elementService.load(memberId, new Relationship[0]);
            }
            catch (Exception e) {
                member = null;
            }
        }
        return member;
    }
}

