/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.sms;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.members.sms.SearchSmsMailingsForm;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.entities.sms.SmsMailingQuery;
import nl.strohalm.cyclos.services.sms.SmsMailingService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;

public class SearchSmsMailingsAction
extends BaseQueryAction
implements LocalSettingsChangeListener {
    private DataBinder<SmsMailingQuery> dataBinder;
    private SmsMailingService smsMailingService;

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        super.onLocalSettingsUpdate(event);
        this.dataBinder = null;
    }

    @Inject
    public void setSmsMailingService(SmsMailingService smsMailingService) {
        this.smsMailingService = smsMailingService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        SmsMailingQuery query = (SmsMailingQuery)queryParameters;
        query.fetch(SmsMailing.Relationships.BY, SmsMailing.Relationships.GROUPS);
        List<SmsMailing> smsMailings = this.smsMailingService.search(query);
        HttpServletRequest request = context.getRequest();
        request.setAttribute("smsMailings", smsMailings);
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        boolean canSend;
        boolean viewPaid;
        boolean viewFree;
        SearchSmsMailingsForm form = (SearchSmsMailingsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        SmsMailingQuery query = this.getDataBinder().readFromString(form.getQuery());
        if (context.isAdmin()) {
            viewPaid = viewFree = this.permissionService.hasPermission(AdminMemberPermission.SMS_MAILINGS_VIEW);
            canSend = this.permissionService.hasPermission(AdminMemberPermission.SMS_MAILINGS_FREE_SMS_MAILINGS) || this.permissionService.hasPermission(AdminMemberPermission.SMS_MAILINGS_PAID_SMS_MAILINGS);
            GroupQuery groupQuery = new GroupQuery();
            groupQuery.setManagedBy((AdminGroup)context.getGroup());
            groupQuery.setOnlyActive(true);
            request.setAttribute("groups", this.groupService.search(groupQuery));
        } else {
            viewFree = this.permissionService.hasPermission(BrokerPermission.SMS_MAILINGS_FREE_SMS_MAILINGS);
            viewPaid = this.permissionService.hasPermission(BrokerPermission.SMS_MAILINGS_PAID_SMS_MAILINGS);
            boolean bl = canSend = viewFree || viewPaid;
        }
        if (query.getMember() != null) {
            query.setMember((Member)this.elementService.load(query.getMember().getId(), Element.Relationships.USER));
        }
        request.setAttribute("viewFree", (Object)viewFree);
        request.setAttribute("viewPaid", (Object)viewPaid);
        request.setAttribute("canSend", (Object)canSend);
        query.fetch(RelationshipHelper.nested(SmsMailing.Relationships.BY, Element.Relationships.GROUP));
        return query;
    }

    @Override
    protected boolean willExecuteQuery(ActionContext context, QueryParameters queryParameters) throws Exception {
        return true;
    }

    private DataBinder<SmsMailingQuery> getDataBinder() {
        if (this.dataBinder == null) {
            LocalSettings settings = this.settingsService.getLocalSettings();
            BeanBinder<SmsMailingQuery> binder = BeanBinder.instance(SmsMailingQuery.class);
            binder.registerBinder("period", DataBinderHelper.periodBinder(settings, "period"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            binder.registerBinder("recipient", PropertyBinder.instance(SmsMailingQuery.Recipient.class, "recipient"));
            binder.registerBinder("group", PropertyBinder.instance(MemberGroup.class, "group"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

