/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.members.sms;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.members.sms.SendSmsMailingForm;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.sms.SmsMailing;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.sms.SmsMailingService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.binding.SimpleCollectionBinder;

public class SendSmsMailingAction
extends BaseFormAction {
    private DataBinder<SmsMailing> dataBinder;
    private SmsMailingService smsMailingService;

    @Inject
    public void setSmsMailingService(SmsMailingService smsMailingService) {
        this.smsMailingService = smsMailingService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        Enum permission;
        SendSmsMailingForm form = (SendSmsMailingForm)((Object)context.getForm());
        SmsMailing smsMailing = this.getDataBinder().readFromString(form.getSmsMailing());
        if (context.isAdmin()) {
            permission = smsMailing.isFree() ? AdminMemberPermission.SMS_MAILINGS_FREE_SMS_MAILINGS : AdminMemberPermission.SMS_MAILINGS_PAID_SMS_MAILINGS;
        } else {
            Enum enum_ = permission = smsMailing.isFree() ? BrokerPermission.SMS_MAILINGS_FREE_SMS_MAILINGS : BrokerPermission.SMS_MAILINGS_PAID_SMS_MAILINGS;
        }
        if (!this.permissionService.hasPermission(new Permission[]{permission})) {
            throw new PermissionDeniedException();
        }
        this.smsMailingService.send(smsMailing);
        context.sendMessage("smsMailing.sent", new Object[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean canSendPaid;
        boolean canSendFree;
        HttpServletRequest request = context.getRequest();
        SendSmsMailingForm form = (SendSmsMailingForm)((Object)context.getForm());
        if (context.isAdmin()) {
            canSendFree = this.permissionService.hasPermission(AdminMemberPermission.SMS_MAILINGS_FREE_SMS_MAILINGS);
            canSendPaid = this.permissionService.hasPermission(AdminMemberPermission.SMS_MAILINGS_PAID_SMS_MAILINGS);
            GroupQuery query = new GroupQuery();
            query.setManagedBy((AdminGroup)context.getGroup());
            query.setOnlyActive(true);
            request.setAttribute("groups", this.groupService.search(query));
        } else {
            canSendFree = this.permissionService.hasPermission(BrokerPermission.SMS_MAILINGS_FREE_SMS_MAILINGS);
            canSendPaid = this.permissionService.hasPermission(BrokerPermission.SMS_MAILINGS_PAID_SMS_MAILINGS);
        }
        request.setAttribute("canSendFree", (Object)canSendFree);
        request.setAttribute("canSendPaid", (Object)canSendPaid);
        if (canSendFree && canSendPaid) {
            form.setSmsMailing("free", "true");
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        SendSmsMailingForm form = (SendSmsMailingForm)((Object)context.getForm());
        SmsMailing smsMailing = this.getDataBinder().readFromString(form.getSmsMailing());
        this.smsMailingService.validate(smsMailing, form.isSingleMember());
    }

    private DataBinder<SmsMailing> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<SmsMailing> binder = BeanBinder.instance(SmsMailing.class);
            binder.registerBinder("free", PropertyBinder.instance(Boolean.TYPE, "free"));
            binder.registerBinder("text", PropertyBinder.instance(String.class, "text"));
            binder.registerBinder("member", PropertyBinder.instance(Member.class, "member"));
            binder.registerBinder("groups", SimpleCollectionBinder.instance(MemberGroup.class, "groups"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

