/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.controls.AbstractActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileHelper;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.MessageHelper;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class MobileActionContext
extends AbstractActionContext {
    private static final long serialVersionUID = -1199519771150330272L;

    public MobileActionContext(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, MessageHelper messageHelper, MemberUser user) {
        super(actionMapping, actionForm, request, response, messageHelper, user);
    }

    public String getChannel() {
        return this.isWap1Request() ? "wap1" : "wap2";
    }

    public MemberAccount getCurrentAccount() {
        return (MemberAccount)this.getSession().getAttribute("mobileAccount");
    }

    public MemberAccountType getCurrentAccountType() {
        return (MemberAccountType)this.getSession().getAttribute("mobileAccountType");
    }

    public Member getElement() {
        return (Member)super.getElement();
    }

    public Member getMember() {
        return this.getElement();
    }

    public MemberUser getUser() {
        return (MemberUser)super.getUser();
    }

    public boolean isWap1Request() {
        return MobileHelper.isWap1Request(this.getRequest());
    }

    public ActionForward sendException(MobileException e) {
        this.getSession().setAttribute("mobileException", (Object)e);
        return this.getActionMapping().findForward(this.isWap1Request() ? "wapError" : "mobileError");
    }

    public void setCurrentAccount(MemberAccount account) {
        this.getSession().setAttribute("mobileAccount", (Object)account);
    }

    public void setCurrentAccountType(MemberAccountType type) {
        this.getSession().setAttribute("mobileAccountType", (Object)type);
    }

    @Override
    protected void validateTransactionPassword(User.TransactionPasswordStatus tpStatus) {
        switch (tpStatus) {
            case BLOCKED: {
                throw new MobileException("mobile.transactionPassword.error.blocked");
            }
            case PENDING: 
            case NEVER_CREATED: {
                throw new MobileException("mobile.transactionPassword.error.pending");
            }
        }
    }
}

