/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.mobile.MobileActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileHelper;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.AccessDeniedException;
import nl.strohalm.cyclos.exceptions.LoggedOutException;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class MobileBaseAction
extends Action {
    private static final Log LOG = LogFactory.getLog(MobileBaseAction.class);
    protected SettingsService settingsService;
    protected LoginHelper loginHelper;
    protected ActionHelper actionHelper;
    protected MessageHelper messageHelper;

    public static ActionForward processForward(ActionForward forward, HttpServletRequest request) {
        if (forward == null || !forward.getRedirect()) {
            return forward;
        }
        ActionForward ret = new ActionForward(forward);
        ret.setPath(ret.getPath() + ";jsessionid=" + request.getSession().getId());
        return ret;
    }

    public final ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            MemberUser user = null;
            try {
                user = this.validate(request, actionMapping);
            }
            catch (MobileException e) {
                throw e;
            }
            catch (AccessDeniedException e) {
                throw new MobileException("error.accessDenied");
            }
            catch (LoggedOutException e) {
                request.getSession().invalidate();
                throw new MobileException("error.loggedOut");
            }
            catch (Exception e) {
                this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
                throw new MobileException();
            }
            MobileHelper.clearException(request);
            try {
                MobileActionContext context = new MobileActionContext(actionMapping, actionForm, request, response, this.messageHelper, user);
                ActionForward forward = this.executeAction(context);
                return MobileBaseAction.processForward(forward, request);
            }
            catch (MobileException e) {
                throw e;
            }
            catch (Exception e) {
                this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
                LOG.error((Object)("Application error on " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
                throw new MobileException();
            }
        }
        catch (MobileException e) {
            return MobileHelper.sendException(actionMapping, request, e);
        }
    }

    @Inject
    public void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }

    @Inject
    public final void setLoginHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    @Inject
    public final void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    protected abstract ActionForward executeAction(MobileActionContext var1) throws Exception;

    protected UnitsConverter getUnitsConverter(MobileActionContext context) {
        LocalSettings settings = this.settingsService.getLocalSettings();
        return settings.getUnitsConverter(context.getCurrentAccountType().getCurrency().getPattern());
    }

    protected void storeBookmark(MobileActionContext context) {
        ActionMapping actionMapping = context.getActionMapping();
        HttpServletRequest request = context.getRequest();
        request.getSession().setAttribute("mobileBookmark", (Object)actionMapping.getPath());
    }

    private MemberUser validate(HttpServletRequest request, ActionMapping actionMapping) throws Exception {
        User user = this.loginHelper.validateLoggedUser(request);
        if (user instanceof MemberUser) {
            String path = actionMapping.getPath();
            if (!path.contains("/wap") && !path.contains("/mobile")) {
                throw new AccessDeniedException();
            }
            return (MemberUser)user;
        }
        throw new MobileException("login.error.admin");
    }
}

