/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import java.util.Map;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.mobile.MobileActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileBaseAction;
import nl.strohalm.cyclos.controls.mobile.MobileConfirmAccountForm;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import org.apache.struts.action.ActionForward;

public class MobileConfirmAccountAction
extends MobileBaseAction {
    private AccountService accountService;

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    protected ActionForward executeAction(MobileActionContext context) throws Exception {
        MobileConfirmAccountForm form = (MobileConfirmAccountForm)((Object)context.getForm());
        Long id = form.getId();
        Map accountTypesById = (Map)context.getSession().getAttribute("accountTypesById");
        MemberAccountType accountType = (MemberAccountType)accountTypesById.get(id);
        context.setCurrentAccountType(accountType);
        Member member = context.getElement();
        AccountDTO accountDto = new AccountDTO();
        accountDto.setOwner(member);
        accountDto.setType(accountType);
        MemberAccount account = (MemberAccount)this.accountService.getAccount(accountDto, RelationshipHelper.nested(Account.Relationships.TYPE, AccountType.Relationships.CURRENCY));
        context.setCurrentAccount(account);
        return context.findForward("success");
    }
}

