/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import java.math.BigDecimal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.mobile.MobileActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileBaseAction;
import nl.strohalm.cyclos.controls.mobile.MobileConfirmPaymentForm;
import nl.strohalm.cyclos.controls.mobile.MobileHelper;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class MobileConfirmPaymentAction
extends MobileBaseAction {
    private TransferTypeService transferTypeService;
    private TransactionFeeService transactionFeeService;
    private PaymentService paymentService;
    private AccessService accessService;
    private ChannelService channelService;

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public TransactionFeeService getTransactionFeeService() {
        return this.transactionFeeService;
    }

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward executeAction(MobileActionContext context) throws Exception {
        boolean requestTransactionPassword;
        HttpServletRequest request = context.getRequest();
        HttpSession session = request.getSession();
        DoPaymentDTO payment = this.validatePayment(session);
        Channel channel = this.channelService.loadByInternalName(MobileHelper.mobileChannel(request));
        boolean bl = requestTransactionPassword = channel.getCredentials() == Channel.Credentials.DEFAULT && context.isTransactionPasswordEnabled(context.getCurrentAccountType());
        if (RequestHelper.isGet(request)) {
            String ttConfirmation;
            UnitsConverter unitsConverter = this.getUnitsConverter(context);
            TransferType transferType = payment.getTransferType() == null ? null : this.transferTypeService.load(payment.getTransferType().getId(), new Relationship[0]);
            String amount = unitsConverter.toString(payment.getAmount());
            Member toMember = (Member)payment.getTo();
            String to = toMember.getName();
            StringBuilder messages = new StringBuilder();
            TransactionFeePreviewDTO preview = this.transactionFeeService.preview(context.getAccountOwner(), toMember, transferType, payment.getAmount());
            if (preview != null && preview.getFees() != null && !preview.getFees().isEmpty()) {
                messages.append("\n\n").append(context.message("payment.confirmation.fees", new Object[0]));
                for (Map.Entry<TransactionFee, BigDecimal> entry : preview.getFees().entrySet()) {
                    messages.append('\n').append(entry.getKey().getName()).append(": ").append(unitsConverter.toString(entry.getValue()));
                }
            }
            if (StringUtils.isNotEmpty((String)(ttConfirmation = transferType.getConfirmationMessage()))) {
                messages.append("\n\n").append(ttConfirmation);
            }
            String message = context.message("mobile.payment.confirmation", amount, to, messages.toString());
            request.setAttribute("confirmationMessage", (Object)message);
            request.setAttribute("requestTransactionPassword", (Object)requestTransactionPassword);
            return context.getInputForward();
        }
        if (requestTransactionPassword) {
            String transactionPassword = this.validateTransactionPassword(context);
            try {
                this.accessService.checkTransactionPassword(transactionPassword);
            }
            catch (InvalidCredentialsException e) {
                throw new MobileException("transactionPassword.error.invalid");
            }
            catch (BlockedCredentialsException e) {
                throw new MobileException("transactionPassword.error.blockedByTrials");
            }
        }
        try {
            this.paymentService.doPayment(payment);
            return context.getSuccessForward();
        }
        catch (CreditsException e) {
            throw new MobileException(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
    }

    private DoPaymentDTO validatePayment(HttpSession session) {
        DoPaymentDTO payment = (DoPaymentDTO)session.getAttribute("mobileDoPaymentDTO");
        if (payment == null || payment.getAmount().compareTo(new BigDecimal(0)) != 1 || !(payment.getTo() instanceof Member) || payment.getTransferType() == null) {
            throw new MobileException("mobile.payment.error.invalid");
        }
        return payment;
    }

    private String validateTransactionPassword(MobileActionContext context) {
        context.validateTransactionPassword();
        MobileConfirmPaymentForm form = (MobileConfirmPaymentForm)((Object)context.getForm());
        String transactionPassword = StringUtils.trimToNull((String)form.getTransactionPassword());
        if (transactionPassword == null) {
            throw new MobileException("errors.required", context.message("mobile.payment.transactionPassword", new Object[0]));
        }
        return transactionPassword.toUpperCase();
    }
}

