/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.mobile.MobileActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileBaseAction;
import nl.strohalm.cyclos.controls.mobile.MobileDoPaymentForm;
import nl.strohalm.cyclos.controls.mobile.MobileHelper;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transactions.exceptions.MaxAmountPerDayExceededException;
import nl.strohalm.cyclos.services.transactions.exceptions.NotEnoughCreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class MobileDoPaymentAction
extends MobileBaseAction {
    private ElementService elementService;
    private PaymentService paymentService;
    private TransferTypeService transferTypeService;

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public TransferTypeService getTransferTypeService() {
        return this.transferTypeService;
    }

    @Inject
    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward executeAction(MobileActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        HttpSession session = request.getSession();
        if (RequestHelper.isGet(request)) {
            if (RequestHelper.isFromMenu(request)) {
                session.removeAttribute("mobileDoPaymentDTO");
            }
            this.storeBookmark(context);
            return context.getInputForward();
        }
        try {
            Member fromMember = context.getMember();
            Member toMember = this.validateTo(context);
            DoPaymentDTO payment = new DoPaymentDTO();
            payment.setChannel(context.getChannel());
            payment.setContext(TransactionContext.PAYMENT);
            payment.setFrom(fromMember);
            payment.setTo(toMember);
            payment.setAmount(this.validateAmount(context));
            payment.setDescription(this.validateDescription(context));
            payment.setTransferType(this.validateTransferType(context, toMember));
            this.validatePayment(payment);
            session.setAttribute("mobileDoPaymentDTO", (Object)payment);
        }
        catch (MobileException e) {
            return MobileHelper.sendException(context.getActionMapping(), request, e);
        }
        return context.getSuccessForward();
    }

    private BigDecimal validateAmount(MobileActionContext context) {
        MobileDoPaymentForm form = (MobileDoPaymentForm)((Object)context.getForm());
        UnitsConverter converter = this.getUnitsConverter(context);
        BigDecimal amount = null;
        try {
            amount = converter.valueOf(form.getAmount());
        }
        catch (Exception e) {
            throw new MobileException("errors.invalid", context.message("mobile.payment.amount", new Object[0]));
        }
        if (amount == null) {
            throw new MobileException("errors.required", context.message("mobile.payment.amount", new Object[0]));
        }
        if (amount.compareTo(this.paymentService.getMinimumPayment()) == -1) {
            throw new MobileException("errors.invalid", context.message("mobile.payment.amount", new Object[0]));
        }
        return amount;
    }

    private String validateDescription(MobileActionContext context) {
        MobileDoPaymentForm form = (MobileDoPaymentForm)((Object)context.getForm());
        return StringUtils.trimToNull((String)form.getDescription());
    }

    private void validatePayment(DoPaymentDTO payment) {
        String key = null;
        String arg = null;
        try {
            this.paymentService.simulatePayment(payment);
        }
        catch (NotEnoughCreditsException e) {
            key = "mobile.payment.error.notEnoughCredits";
        }
        catch (MaxAmountPerDayExceededException e) {
            Calendar date = e.getDate();
            if (date == null || DateHelper.sameDay(date, Calendar.getInstance())) {
                key = "mobile.payment.error.maxAmountPerDay";
            } else {
                key = "mobile.payment.error.maxAmountPerDay.at";
                arg = this.settingsService.getLocalSettings().getRawDateConverter().toString(date);
            }
        }
        catch (UnexpectedEntityException e) {
            key = "mobile.payment.error.noTransferType";
        }
        if (key != null) {
            throw new MobileException(key, arg);
        }
    }

    private Member validateTo(MobileActionContext context) {
        Object user;
        MobileDoPaymentForm form = (MobileDoPaymentForm)((Object)context.getForm());
        String username = form.getUsername();
        if (StringUtils.isEmpty((String)username)) {
            throw new MobileException("errors.required", context.message("mobile.payment.username", new Object[0]));
        }
        try {
            user = this.elementService.loadUser(username, User.Relationships.ELEMENT);
            if (!(user instanceof MemberUser) || context.getUser().equals(user)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new MobileException("errors.invalid", context.message("mobile.payment.username", new Object[0]));
        }
        return (Member)((User)user).getElement();
    }

    private TransferType validateTransferType(MobileActionContext context, AccountOwner to) {
        TransferTypeQuery query = new TransferTypeQuery();
        query.setUniqueResult();
        query.setFromAccountType(context.getCurrentAccountType());
        query.setChannel(context.getChannel());
        query.setContext(TransactionContext.PAYMENT);
        query.setFromOwner(context.getAccountOwner());
        query.setToOwner(to);
        query.setUsePriority(true);
        List<TransferType> types = this.transferTypeService.search(query);
        if (types == null || types.isEmpty()) {
            throw new MobileException("mobile.payment.error.noTransferType");
        }
        return types.get(0);
    }
}

