/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public final class MobileHelper {
    public static void clearException(HttpServletRequest request) {
        request.getSession().removeAttribute("mobileException");
    }

    public static ActionForward getErrorForward(ActionMapping actionMapping, HttpServletRequest request) {
        String forward = MobileHelper.isWap1Request(request) ? "wapError" : "mobileError";
        return actionMapping.findForward(forward);
    }

    public static ActionForward getHomeForward(ActionMapping actionMapping, HttpServletRequest request) {
        String forward = MobileHelper.isWap1Request(request) ? "wapHome" : "mobileHome";
        return actionMapping.findForward(forward);
    }

    public static boolean isWap1Request(HttpServletRequest request) {
        return request.getRequestURI().contains("/wap");
    }

    public static boolean isWap2Request(HttpServletRequest request) {
        return request.getRequestURI().contains("/mobile");
    }

    public static String mobileChannel(HttpServletRequest request) {
        if (MobileHelper.isWap1Request(request)) {
            return "wap1";
        }
        return "wap2";
    }

    public static ActionForward sendException(ActionMapping actionMapping, HttpServletRequest request, MobileException e) {
        request.getSession().setAttribute("mobileException", (Object)e);
        return MobileHelper.getErrorForward(actionMapping, request);
    }
}

