/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.mobile.MobileActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileBaseAction;
import nl.strohalm.cyclos.controls.mobile.MobileHelper;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import org.apache.struts.action.ActionForward;

public class MobileHomeAction
extends MobileBaseAction {
    private AccountService accountService;

    public AccountService getAccountService() {
        return this.accountService;
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Override
    protected ActionForward executeAction(MobileActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        MemberAccount account = context.getCurrentAccount();
        request.setAttribute("account", (Object)account);
        MemberAccountType accountType = context.getCurrentAccountType();
        if (accountType == null) {
            context.getSession().invalidate();
            if (MobileHelper.isWap1Request(request)) {
                return new ActionForward("/wap", true);
            }
            return new ActionForward("/mobile", true);
        }
        request.setAttribute("accountType", (Object)accountType);
        request.setAttribute("unitsPattern", (Object)accountType.getCurrency().getPattern());
        AccountDTO dto = new AccountDTO(context.getMember(), accountType);
        request.setAttribute("status", (Object)this.accountService.getCurrentStatus(dto));
        Boolean multipleAccounts = (Boolean)context.getSession().getAttribute("multipleAccounts");
        request.setAttribute("multipleAccounts", (Object)multipleAccounts);
        return context.getInputForward();
    }
}

