/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.access.LoginForm;
import nl.strohalm.cyclos.controls.mobile.MobileBaseAction;
import nl.strohalm.cyclos.controls.mobile.MobileHelper;
import nl.strohalm.cyclos.controls.mobile.exceptions.InvalidUserForMobileException;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.PrincipalType;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.AccessDeniedException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.access.AccessService;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.access.exceptions.AlreadyConnectedException;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InactiveMemberException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidUserForChannelException;
import nl.strohalm.cyclos.services.access.exceptions.LoginException;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.MemberAccountTypeQuery;
import nl.strohalm.cyclos.services.groups.GroupFilterService;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.LoginHelper;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class MobileLoginAction
extends Action {
    private static final Log LOG = LogFactory.getLog(MobileLoginAction.class);
    private AccessService accessService;
    private AccountService accountService;
    private AccountTypeService accountTypeService;
    private ChannelService channelService;
    private GroupService groupService;
    private GroupFilterService groupFilterService;
    protected ActionHelper actionHelper;
    protected LoginHelper loginHelper;
    protected MessageHelper messageHelper;

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        User user = LoginHelper.getLoggedUser(request);
        if (user != null) {
            if (user instanceof MemberUser) {
                String channel = MobileHelper.mobileChannel(request);
                if (!this.accessService.isChannelEnabledForMember(channel, ((MemberUser)user).getMember())) {
                    session.invalidate();
                    return MobileHelper.sendException(actionMapping, request, new InvalidUserForMobileException());
                }
                return MobileHelper.getHomeForward(actionMapping, request);
            }
            session.invalidate();
            return MobileHelper.sendException(actionMapping, request, new InvalidUserForMobileException());
        }
        String queryString = StringUtils.trimToNull((String)request.getQueryString());
        if (queryString != null) {
            try {
                GroupFilter groupFilter = this.groupFilterService.findByLoginPageName(queryString);
                request.setAttribute("styleGroupFilter", (Object)groupFilter);
            }
            catch (EntityNotFoundException e) {
                try {
                    SystemGroup group = this.groupService.findByLoginPageName(queryString);
                    request.setAttribute("styleGroup", (Object)group);
                }
                catch (EntityNotFoundException e1) {
                    // empty catch block
                }
            }
        }
        if (RequestHelper.isGet(request)) {
            session.setAttribute("loginQueryString", (Object)queryString);
        }
        ActionForward forward = null;
        try {
            if (RequestHelper.isGet(request)) {
                forward = this.prepareForm(actionMapping, actionForm, request, response);
            } else if (RequestHelper.isPost(request)) {
                forward = this.doLogin(actionMapping, actionForm, request, response);
            }
        }
        catch (MobileException e) {
            return MobileHelper.sendException(actionMapping, request, e);
        }
        return MobileBaseAction.processForward(forward, request);
    }

    @Inject
    public void setAccessService(AccessService accessService) {
        this.accessService = accessService;
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setGroupFilterService(GroupFilterService groupFilterService) {
        this.groupFilterService = groupFilterService;
    }

    @Inject
    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Inject
    public final void setLoginHelper(LoginHelper loginHelper) {
        this.loginHelper = loginHelper;
    }

    @Inject
    public void setMessageHelper(MessageHelper messageHelper) {
        this.messageHelper = messageHelper;
    }

    private Map<String, String> createLink(HttpServletRequest request, String label, String paramName, String paramValue) {
        HashMap<String, String> link = new HashMap<String, String>();
        link.put("label", label);
        link.put("paramName", paramName);
        link.put("paramValue", paramValue);
        return link;
    }

    private ActionForward doLogin(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        try {
            MemberAccountType accountType;
            User user;
            String channelName = MobileHelper.mobileChannel(request);
            Channel channel = this.channelService.loadByInternalName(channelName);
            LoginForm form = (LoginForm)actionForm;
            String principal = form.getPrincipal();
            String credentials = form.getPassword();
            if (channel.getCredentials() == Channel.Credentials.TRANSACTION_PASSWORD) {
                credentials = credentials.toUpperCase();
            }
            try {
                user = this.loginHelper.login(MemberUser.class, form.getPrincipalType(), null, principal, credentials, channelName, request, response);
                session = request.getSession();
            }
            catch (AccessDeniedException e) {
                session.invalidate();
                throw new InvalidUserForMobileException();
            }
            catch (AlreadyConnectedException e) {
                return MobileHelper.sendException(actionMapping, request, new MobileException("login.error.alreadyConnected"));
            }
            catch (InvalidUserForChannelException e) {
                session.invalidate();
                return MobileHelper.sendException(actionMapping, request, new InvalidUserForMobileException());
            }
            Member member = ((MemberUser)user).getMember();
            MemberGroup memberGroup = member.getMemberGroup();
            MemberAccountTypeQuery atQuery = new MemberAccountTypeQuery();
            atQuery.fetch(AccountType.Relationships.CURRENCY);
            atQuery.setRelatedToGroup(memberGroup);
            List<? extends AccountType> accountTypes = this.accountTypeService.search(atQuery);
            if (accountTypes.isEmpty()) {
                session.invalidate();
                throw new MobileException("mobile.error.inactiveUser");
            }
            boolean multipleAccounts = false;
            if (accountTypes.size() > 1) {
                multipleAccounts = true;
                HashMap<Long, MemberAccountType> accountTypesById = new HashMap<Long, MemberAccountType>();
                for (MemberAccountType memberAccountType : accountTypes) {
                    accountTypesById.put(memberAccountType.getId(), memberAccountType);
                }
                session.setAttribute("accountTypes", accountTypes);
                session.setAttribute("accountTypesById", accountTypesById);
            }
            if ((accountType = this.accountTypeService.getDefault(memberGroup, AccountType.Relationships.CURRENCY)) == null) {
                accountType = (MemberAccountType)accountTypes.get(0);
            }
            AccountDTO accountDto = new AccountDTO();
            accountDto.setOwner(member);
            accountDto.setType(accountType);
            MemberAccount memberAccount = (MemberAccount)this.accountService.getAccount(accountDto, new Relationship[0]);
            session.setAttribute("mobileAccount", (Object)memberAccount);
            session.setAttribute("mobileAccountType", (Object)accountType);
            session.setAttribute("multipleAccounts", (Object)multipleAccounts);
            return actionMapping.findForward("success");
        }
        catch (InactiveMemberException e) {
            throw new MobileException("login.error.inactive");
        }
        catch (BlockedCredentialsException e) {
            String key = e.getCredentialsType() == Channel.Credentials.TRANSACTION_PASSWORD ? "transactionPassword.error.blockedByTrials" : "login.error.blocked";
            throw new MobileException(key);
        }
        catch (InvalidCredentialsException e) {
            String key = e.getCredentialsType() == Channel.Credentials.TRANSACTION_PASSWORD ? "transactionPassword.error.invalid" : "login.error";
            throw new MobileException(key);
        }
        catch (LoginException e) {
            throw new MobileException("login.error");
        }
        catch (PermissionDeniedException e) {
            throw new MobileException("error.accessDenied");
        }
        catch (MobileException e) {
            throw e;
        }
        catch (Exception e) {
            this.actionHelper.generateLog(request, this.getServlet().getServletContext(), e);
            LOG.error((Object)"Application error on mobile login action", (Throwable)e);
            throw new MobileException();
        }
    }

    private ActionForward prepareForm(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Channel channel = this.channelService.loadByInternalName(MobileHelper.mobileChannel(request));
        Channel.Credentials credentials = channel.getCredentials();
        if (credentials == Channel.Credentials.DEFAULT) {
            credentials = Channel.Credentials.LOGIN_PASSWORD;
        }
        request.setAttribute("credentials", (Object)credentials);
        LoginForm form = (LoginForm)actionForm;
        ArrayList<Map<String, String>> accessLinks = new ArrayList<Map<String, String>>();
        PrincipalType selectedPrincipalType = StringUtils.isEmpty((String)form.getPrincipalType()) ? channel.getDefaultPrincipalType() : this.channelService.resolvePrincipalType(channel.getInternalName(), form.getPrincipalType());
        Set<PrincipalType> allPrincipalTypes = channel.getPrincipalTypes();
        for (PrincipalType principalType : allPrincipalTypes) {
            if (principalType.equals(selectedPrincipalType)) continue;
            String label = this.messageHelper.message("mobile.login.accessUsing", this.resolvePrincipalLabel(principalType));
            accessLinks.add(this.createLink(request, label, "principalType", principalType.toString()));
        }
        request.setAttribute("selectedPrincipalType", (Object)selectedPrincipalType);
        request.setAttribute("selectedPrincipalLabel", (Object)this.resolvePrincipalLabel(selectedPrincipalType));
        request.setAttribute("accessLinks", accessLinks);
        return actionMapping.getInputForward();
    }

    private String resolvePrincipalLabel(PrincipalType principalType) {
        Channel.Principal principal = principalType.getPrincipal();
        if (principal == Channel.Principal.CUSTOM_FIELD) {
            return principalType.getCustomField().getName();
        }
        return this.messageHelper.message(principal.getKey(), new Object[0]);
    }
}

