/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.mobile;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.mobile.MobileActionContext;
import nl.strohalm.cyclos.controls.mobile.MobileBaseAction;
import nl.strohalm.cyclos.controls.mobile.MobileViewPaymentsForm;
import nl.strohalm.cyclos.controls.mobile.exceptions.MobileException;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.utils.query.Page;
import nl.strohalm.cyclos.utils.query.PageParameters;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import org.apache.struts.action.ActionForward;

public class MobileViewPaymentsAction
extends MobileBaseAction {
    private PaymentService paymentService;

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    protected ActionForward executeAction(MobileActionContext context) throws Exception {
        MobileViewPaymentsForm form = (MobileViewPaymentsForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        TransferQuery query = new TransferQuery();
        query.setPageParameters(new PageParameters(1, form.getCurrent()));
        query.setOwner(context.getAccountOwner());
        query.setType(context.getCurrentAccountType());
        query.fetch(Payment.Relationships.FROM, Payment.Relationships.TO, Payment.Relationships.TYPE);
        query.setReverseOrder(true);
        query.setResultType(QueryParameters.ResultType.PAGE);
        Page page = (Page)this.paymentService.search(query);
        int total = page.getPageCount();
        int current = page.getCurrentPage();
        if (page == null || page.isEmpty() || total == 0) {
            throw new MobileException(true, "mobile.viewPayments.title", "mobile.viewPayments.noPayment", new Object[0]);
        }
        Transfer payment = (Transfer)page.get(0);
        boolean isDebit = context.getAccountOwner().equals(payment.getFrom().getOwner());
        request.setAttribute("payment", (Object)payment);
        request.setAttribute("isDebit", (Object)isDebit);
        BigDecimal amount = payment.getAmount();
        if (isDebit) {
            amount = amount.negate();
        }
        request.setAttribute("amount", (Object)this.getUnitsConverter(context).toString(amount));
        request.setAttribute("previous", current > 0 ? Integer.valueOf(current - 1) : null);
        request.setAttribute("next", current < total - 1 ? Integer.valueOf(current + 1) : null);
        return context.getInputForward();
    }
}

