/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.operators;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.ChangeElementGroupAction;
import nl.strohalm.cyclos.controls.operators.ChangeOperatorGroupForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ChangeOperatorGroupAction
extends ChangeElementGroupAction {
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ChangeOperatorGroupForm form = (ChangeOperatorGroupForm)((Object)context.getForm());
        ActionForward forward = ActionHelper.redirectWithParam(context.getRequest(), super.handleSubmit(context), "operatorId", form.getOperatorId());
        String key = "changeGroup.operator.changed";
        if (CurrentTransactionData.hasMailError()) {
            key = key + ".mailError";
        }
        context.sendMessage(key, new Object[0]);
        return forward;
    }

    @Override
    protected ActionForward handleValidation(ActionContext context) {
        try {
            this.validateForm(context);
            ChangeOperatorGroupForm form = (ChangeOperatorGroupForm)((Object)context.getForm());
            Object newGroup = this.groupService.load(form.getNewGroupId(), new Relationship[0]);
            if (((Group)newGroup).getStatus() == Group.Status.REMOVED) {
                HashMap<String, String> fields = new HashMap<String, String>();
                fields.put("confirmationMessage", context.message("changeGroup.confirmRemove", ((Group)newGroup).getName()));
                this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, fields);
            } else {
                this.responseHelper.writeValidationSuccess(context.getResponse());
            }
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
        return null;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        super.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        Operator operator = (Operator)request.getAttribute("element");
        request.setAttribute("operator", (Object)operator);
    }
}

