/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.operators;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.CreateElementAction;
import nl.strohalm.cyclos.controls.operators.CreateOperatorForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class CreateOperatorAction
extends CreateElementAction<Operator> {
    private OperatorCustomFieldService operatorCustomFieldService;

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Override
    protected ActionForward create(Element element, ActionContext context) {
        ActionForward forward;
        Long paramValue;
        String paramName;
        CreateOperatorForm form = (CreateOperatorForm)((Object)context.getForm());
        this.ensureMember(context, element);
        Operator operator = (Operator)this.elementService.register(element, false, context.getRequest().getRemoteAddr());
        String successKey = "operator.created";
        boolean sendMessage = false;
        if (CurrentTransactionData.hasMailError()) {
            successKey = successKey + ".mailError";
            sendMessage = true;
        }
        if (form.isOpenProfile()) {
            paramName = "operatorId";
            paramValue = operator.getId();
            forward = context.findForward("profile");
        } else {
            sendMessage = true;
            paramName = "groupId";
            paramValue = operator.getGroup().getId();
            forward = context.findForward("new");
        }
        if (sendMessage) {
            context.sendMessage(successKey, new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), forward, paramName, paramValue);
    }

    @Override
    protected Class<OperatorCustomField> getCustomFieldClass() {
        return OperatorCustomField.class;
    }

    @Override
    protected Class<OperatorCustomFieldValue> getCustomFieldValueClass() {
        return OperatorCustomFieldValue.class;
    }

    @Override
    protected Class<Operator> getElementClass() {
        return Operator.class;
    }

    @Override
    protected Class<OperatorGroup> getGroupClass() {
        return OperatorGroup.class;
    }

    @Override
    protected Class<OperatorUser> getUserClass() {
        return OperatorUser.class;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        CreateOperatorForm form = (CreateOperatorForm)((Object)context.getForm());
        long groupId = form.getGroupId();
        if (groupId <= 0L) {
            throw new ValidationException();
        }
        OperatorGroup group = (OperatorGroup)this.groupService.load(groupId, new Relationship[0]);
        List<OperatorCustomField> customFields = this.operatorCustomFieldService.list((Member)context.getElement());
        request.setAttribute("customFields", customFields);
        request.setAttribute("group", (Object)group);
    }

    @Override
    protected void runValidation(ActionContext context, Element element) {
        this.ensureMember(context, element);
        this.elementService.validate(element, WhenSaving.OPERATOR, true);
    }

    private void ensureMember(ActionContext context, Element element) {
        Operator operator = (Operator)element;
        if (operator.getMember() == null) {
            operator.setMember(context.getMember());
        }
    }
}

