/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.operators;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.ProfileAction;
import nl.strohalm.cyclos.controls.operators.OperatorProfileForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.OperatorUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.access.exceptions.NotConnectedException;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.elements.WhenSaving;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class OperatorProfileAction
extends ProfileAction<Operator> {
    private static final Relationship[] FETCH = new Relationship[]{RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP), RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.USER), RelationshipHelper.nested(User.Relationships.ELEMENT, Operator.Relationships.CUSTOM_VALUES), RelationshipHelper.nested(User.Relationships.ELEMENT, Operator.Relationships.MEMBER)};
    private OperatorCustomFieldService operatorCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setOperatorCustomFieldService(OperatorCustomFieldService operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Override
    protected <CFV extends CustomFieldValue> Class<CFV> getCustomFieldValueClass() {
        return OperatorCustomFieldValue.class;
    }

    @Override
    protected Class<Operator> getElementClass() {
        return Operator.class;
    }

    @Override
    protected <G extends Group> Class<G> getGroupClass() {
        return OperatorGroup.class;
    }

    @Override
    protected <U extends User> Class<U> getUserClass() {
        return OperatorUser.class;
    }

    @Override
    protected ActionForward handleDisplay(ActionContext context) throws Exception {
        OperatorProfileForm form = (OperatorProfileForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        boolean myProfile = false;
        Long operatorId = form.getOperatorId();
        OperatorUser operatorUser = null;
        Operator operator = null;
        Object loggedElement = context.getElement();
        if (context.isMember()) {
            if (operatorId <= 0L) {
                throw new ValidationException();
            }
            Object loaded = this.elementService.loadUser(operatorId, FETCH);
            if (!(loaded instanceof OperatorUser)) {
                throw new ValidationException();
            }
            operatorUser = (OperatorUser)loaded;
            operator = operatorUser.getOperator();
            if (!operator.getMember().equals(loggedElement)) {
                throw new ValidationException();
            }
            try {
                request.setAttribute("isLoggedIn", (Object)this.accessService.isLoggedIn(operatorUser));
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            request.setAttribute("disabledLogin", (Object)this.accessService.isLoginBlocked(operatorUser));
        } else if (operatorId <= 0L || operatorId.equals(((Entity)context.getElement()).getId())) {
            operatorUser = (OperatorUser)this.elementService.loadUser(((Entity)context.getUser()).getId(), FETCH);
            operator = operatorUser.getOperator();
            myProfile = true;
        } else {
            throw new ValidationException();
        }
        this.getReadDataBinder(context).writeAsString(form.getOperator(), operator);
        List<OperatorCustomField> customFields = this.operatorCustomFieldService.list(operator.getMember());
        HashMap<OperatorCustomField, Boolean> editableFields = new HashMap<OperatorCustomField, Boolean>();
        Iterator<OperatorCustomField> it = customFields.iterator();
        while (it.hasNext()) {
            OperatorCustomField field = it.next();
            OperatorCustomField.Visibility visibility = field.getVisibility();
            if (myProfile && visibility == OperatorCustomField.Visibility.NOT_VISIBLE) {
                it.remove();
                continue;
            }
            editableFields.put(field, !myProfile || visibility == OperatorCustomField.Visibility.EDITABLE);
        }
        request.setAttribute("operator", (Object)operator);
        request.setAttribute("removed", (Object)(operator.getGroup().getStatus() == Group.Status.REMOVED ? 1 : 0));
        request.setAttribute("customFields", this.customFieldHelper.buildEntries(customFields, operator.getCustomValues()));
        request.setAttribute("myProfile", (Object)myProfile);
        request.setAttribute("editableFields", editableFields);
        return context.getInputForward();
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        OperatorProfileForm form = (OperatorProfileForm)((Object)context.getForm());
        Operator operator = (Operator)this.getWriteDataBinder(context).readFromString(form.getOperator());
        operator = this.elementService.changeProfile(operator);
        context.sendMessage("profile.modified", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), super.handleSubmit(context), "operatorId", operator.getId());
    }

    @Override
    protected DataBinder<Operator> initDataBinderForRead(ActionContext context) {
        BeanBinder dataBinder = (BeanBinder)super.initDataBinderForRead(context);
        return dataBinder;
    }

    @Override
    protected DataBinder<Operator> initDataBinderForWrite(ActionContext context) {
        BeanBinder dataBinder = (BeanBinder)super.initDataBinderForWrite(context);
        BeanBinder<OperatorCustomFieldValue> customValueBinder = BeanBinder.instance(OperatorCustomFieldValue.class);
        customValueBinder.registerBinder("field", PropertyBinder.instance(OperatorCustomField.class, "field", ReferenceConverter.instance(OperatorCustomField.class)));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
        BeanCollectionBinder collectionBinder = (BeanCollectionBinder)dataBinder.getMappings().get("customValues");
        collectionBinder.setElementBinder(customValueBinder);
        return dataBinder;
    }

    @Override
    protected void validateForm(ActionContext context) {
        OperatorProfileForm form = (OperatorProfileForm)((Object)context.getForm());
        Operator operator = (Operator)this.getWriteDataBinder(context).readFromString(form.getOperator());
        this.elementService.validate(operator, WhenSaving.PROFILE, false);
    }
}

