/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.operators;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.elements.SearchElementsAction;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomFieldValue;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.members.FullTextOperatorQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchOperatorsAction
extends SearchElementsAction<FullTextOperatorQuery> {
    @Override
    protected Class<? extends CustomFieldValue> getCustomFieldValueClass() {
        return OperatorCustomFieldValue.class;
    }

    @Override
    protected Class<FullTextOperatorQuery> getQueryClass() {
        return FullTextOperatorQuery.class;
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        Member loggedMember = (Member)context.getElement();
        GroupQuery possibleGroupQuery = new GroupQuery();
        possibleGroupQuery.setNatures(Group.Nature.OPERATOR);
        possibleGroupQuery.setStatus(Group.Status.NORMAL);
        possibleGroupQuery.setMember(loggedMember);
        List<? extends Group> possibleNewGroups = this.groupService.search(possibleGroupQuery);
        if (possibleNewGroups.isEmpty()) {
            throw new ValidationException(new ValidationError("operator.noGroup", new Object[0]));
        }
        FullTextOperatorQuery query = (FullTextOperatorQuery)super.prepareForm(context);
        query.setMember(loggedMember);
        query.setEnabled(null);
        GroupQuery groupQuery = new GroupQuery();
        groupQuery.setNatures(Group.Nature.OPERATOR);
        groupQuery.setMember(loggedMember);
        request.setAttribute("groups", this.groupService.search(groupQuery));
        request.setAttribute("possibleNewGroups", possibleNewGroups);
        return query;
    }
}

