/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.payments.BasePaymentForm;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountTypeService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.HtmlConverter;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;

public abstract class BasePaymentAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    protected AccountTypeService accountTypeService;
    protected PaymentService paymentService;
    protected CurrencyService currencyService;
    protected TransferTypeService transferTypeService;
    private DataBinder<DoPaymentDTO> dataBinder;

    public DataBinder<DoPaymentDTO> getDataBinder() {
        if (this.dataBinder == null) {
            this.dataBinder = this.initDataBinder();
        }
        return this.dataBinder;
    }

    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        this.dataBinder = null;
    }

    @Inject
    public final void setAccountTypeService(AccountTypeService accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Inject
    public final void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public final void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public final void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        DoPaymentDTO dto = this.resolvePaymentDTO(context);
        context.getSession().setAttribute("payment", (Object)dto);
    }

    protected abstract AccountOwner getFromOwner(ActionContext var1);

    protected PaymentService getPaymentService() {
        return this.paymentService;
    }

    protected DataBinder<DoPaymentDTO> initDataBinder() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        BeanBinder<PaymentCustomFieldValue> customValueBinder = BeanBinder.instance(PaymentCustomFieldValue.class);
        customValueBinder.registerBinder("field", PropertyBinder.instance(PaymentCustomField.class, "field"));
        customValueBinder.registerBinder("value", PropertyBinder.instance(String.class, "value", HtmlConverter.instance()));
        BeanBinder<DoPaymentDTO> binder = BeanBinder.instance(DoPaymentDTO.class);
        binder.registerBinder("from", PropertyBinder.instance(AccountOwner.class, "from", AccountOwnerConverter.instance()));
        binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "type"));
        binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
        binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
        binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
        binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
        binder.registerBinder("customValues", BeanCollectionBinder.instance(customValueBinder, "customValues"));
        return binder;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Object element;
        BasePaymentForm form = (BasePaymentForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        Long fromId = IdConverter.instance().valueOf(form.getFrom());
        boolean asMember = fromId != null;
        Member fromMember = null;
        if (asMember && (element = this.elementService.load(fromId, Element.Relationships.GROUP, Element.Relationships.USER)) instanceof Member) {
            fromMember = (Member)element;
            request.setAttribute("member", (Object)fromMember);
        }
        request.setAttribute("asMember", (Object)asMember);
        Member member = fromMember;
        if (member == null && context.isMember()) {
            member = (Member)context.getElement();
        }
        List<Currency> currencies = this.resolveCurrencies(context);
        TransferTypeQuery ttQuery = this.resolveTransferTypeQuery(context);
        if (ttQuery != null) {
            MemberAccountType defaultAccountType;
            Currency defaultCurrency = null;
            if (member != null && (defaultAccountType = this.accountTypeService.getDefault(member.getMemberGroup(), AccountType.Relationships.CURRENCY)) != null) {
                defaultCurrency = defaultAccountType.getCurrency();
            }
            LinkedHashMap<Currency, List<TransferType>> transferTypesPerCurrency = new LinkedHashMap<Currency, List<TransferType>>();
            ArrayList<TransferType> allTransferTypes = new ArrayList<TransferType>();
            Iterator<Currency> iterator = currencies.iterator();
            while (iterator.hasNext()) {
                Currency currency = iterator.next();
                TransferTypeQuery currentQuery = (TransferTypeQuery)ttQuery.clone();
                currentQuery.setCurrency(currency);
                List<TransferType> tts = this.transferTypeService.search(currentQuery);
                allTransferTypes.addAll(tts);
                if (tts.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                transferTypesPerCurrency.put(currency, tts);
            }
            Currency currency = null;
            if (CollectionUtils.isNotEmpty((Collection)((Collection)transferTypesPerCurrency.get(defaultCurrency)))) {
                currency = defaultCurrency;
            } else if (!transferTypesPerCurrency.isEmpty()) {
                currency = (Currency)transferTypesPerCurrency.keySet().iterator().next();
            }
            form.setCurrency(CoercionHelper.coerce(String.class, currency));
            request.setAttribute("transferTypes", allTransferTypes);
        }
        if (CollectionUtils.isEmpty(currencies)) {
            throw new ValidationException("payment.error.noTransferType", new Object[0]);
        }
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.iterator().next());
        }
    }

    protected List<Currency> resolveCurrencies(ActionContext context) {
        List<Currency> currencies;
        BasePaymentForm form = (BasePaymentForm)((Object)context.getForm());
        HttpServletRequest request = context.getRequest();
        AccountOwner fromOwner = this.getFromOwner(context);
        if (fromOwner instanceof Member) {
            Member member = (Member)this.elementService.load(((Member)fromOwner).getId(), Element.Relationships.GROUP);
            currencies = this.currencyService.listByMember(member);
            MemberAccountType defaultAccountType = this.accountTypeService.getDefault(member.getMemberGroup(), AccountType.Relationships.CURRENCY);
            if (defaultAccountType != null) {
                form.setCurrency(CoercionHelper.coerce(String.class, defaultAccountType.getCurrency()));
            }
        } else {
            currencies = this.currencyService.listAll();
        }
        request.setAttribute("currencies", currencies);
        if (currencies.isEmpty()) {
            throw new ValidationException("payment.error.noTransferType", new Object[0]);
        }
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.get(0));
        }
        return currencies;
    }

    protected DoPaymentDTO resolvePaymentDTO(ActionContext context) {
        return this.getDataBinder().readFromString(context.getForm());
    }

    protected abstract TransferTypeQuery resolveTransferTypeQuery(ActionContext var1);

    @Override
    protected void validateForm(ActionContext context) {
        DoPaymentDTO dto = this.resolvePaymentDTO(context);
        this.paymentService.validate(dto);
    }
}

