/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAjaxAction;
import nl.strohalm.cyclos.controls.payments.CalculatePaymentsAjaxForm;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ProjectionDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class CalculatePaymentsAjaxAction
extends BaseAjaxAction
implements LocalSettingsChangeListener {
    private DataBinder<ProjectionDTO> dtoBinder;
    private DataBinder<Collection<ScheduledPaymentDTO>> paymentBinder;
    private PaymentService paymentService;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dtoBinder = null;
            this.paymentBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    protected BaseAjaxAction.ContentType contentType() {
        return BaseAjaxAction.ContentType.XML;
    }

    @Override
    protected void renderContent(ActionContext context) throws Exception {
        try {
            CalculatePaymentsAjaxForm form = (CalculatePaymentsAjaxForm)((Object)context.getForm());
            ProjectionDTO projection = this.getDtoBinder().readFromString((Object)form);
            if (projection.getFrom() == null) {
                projection.setFrom(context.getAccountOwner());
            }
            List<ScheduledPaymentDTO> payments = this.paymentService.calculatePaymentProjection(projection);
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("payments", this.getPaymentBinder().readAsString(payments));
            this.responseHelper.writeStatus(context.getResponse(), (Object)ResponseHelper.Status.SUCCESS, values);
        }
        catch (ValidationException e) {
            this.responseHelper.writeValidationErrors(context.getResponse(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<ProjectionDTO> getDtoBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dtoBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<ProjectionDTO> binder = BeanBinder.instance(ProjectionDTO.class);
                binder.registerBinder("from", PropertyBinder.instance(AccountOwner.class, "from", AccountOwnerConverter.instance()));
                binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                binder.registerBinder("firstExpirationDate", PropertyBinder.instance(Calendar.class, "firstPaymentDate", localSettings.getRawDateConverter()));
                binder.registerBinder("paymentCount", PropertyBinder.instance(Integer.TYPE, "paymentCount"));
                binder.registerBinder("recurrence", DataBinderHelper.timePeriodBinder("recurrence"));
                this.dtoBinder = binder;
            }
            DataBinder<ProjectionDTO> dataBinder = this.dtoBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<Collection<ScheduledPaymentDTO>> getPaymentBinder() {
        try {
            this.lock.readLock().lock();
            if (this.paymentBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<ScheduledPaymentDTO> binder = BeanBinder.instance(ScheduledPaymentDTO.class);
                binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                this.paymentBinder = BeanCollectionBinder.instance(binder);
            }
            DataBinder<Collection<ScheduledPaymentDTO>> dataBinder = this.paymentBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

