/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.accounts.details.ViewTransactionAction;
import nl.strohalm.cyclos.controls.payments.ChargebackPaymentForm;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class ChargebackPaymentAction
extends ViewTransactionAction {
    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        Transfer chargeback;
        ChargebackPaymentForm form = (ChargebackPaymentForm)((Object)context.getForm());
        long transferId = form.getTransferId();
        if (transferId <= 0L) {
            throw new ValidationException();
        }
        Transfer transfer = this.paymentService.load(transferId, Payment.Relationships.FROM);
        this.checkTransactionPassword(context, transfer);
        try {
            chargeback = this.paymentService.chargeback(transfer);
        }
        catch (CreditsException e) {
            return context.sendError(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        context.sendMessage("payment.chargedBack", new Object[0]);
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "transferId", chargeback.getId());
    }
}

