/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.payments.ConfirmPaymentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class ConfirmPaymentAction
extends BaseFormAction {
    private PaymentService paymentService;
    private TransferTypeService transferTypeService;
    private TransactionFeeService transactionFeeService;
    private PaymentCustomFieldService paymentCustomFieldService;
    private CustomFieldHelper customFieldHelper;

    @Inject
    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    @Inject
    public void setPaymentCustomFieldService(PaymentCustomFieldService paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        ActionForward forward;
        Payment payment;
        ConfirmPaymentForm form = (ConfirmPaymentForm)((Object)context.getForm());
        DoPaymentDTO paymentDTO = this.validatePayment(context);
        if (this.shouldValidateTransactionPassword(context, paymentDTO)) {
            context.checkTransactionPassword(form.getTransactionPassword());
        }
        try {
            payment = this.paymentService.doPayment(paymentDTO);
            context.getSession().removeAttribute("payment");
        }
        catch (CreditsException e) {
            return context.sendError(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (UnexpectedEntityException e) {
            return context.sendError("payment.error.invalidTransferType", new Object[0]);
        }
        catch (AuthorizedPaymentInPastException e) {
            return context.sendError("payment.error.authorizedInPast", new Object[0]);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (payment instanceof Transfer) {
            params.put("transferId", payment.getId());
            forward = context.getSuccessForward();
        } else if (payment instanceof ScheduledPayment) {
            params.put("paymentId", payment.getId());
            forward = context.findForward("scheduledPayment");
        } else {
            throw new IllegalStateException("Unknown payment type: " + payment);
        }
        params.put("selectMember", form.getSelectMember());
        params.put("from", form.getFrom());
        return ActionHelper.redirectWithParams(context.getRequest(), forward, params);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        List<ScheduledPaymentDTO> payments;
        boolean isScheduled;
        DoPaymentDTO payment = this.validatePayment(context);
        if (payment.getFrom() != null && context.getAccountOwner().equals(payment.getFrom())) {
            payment.setFrom(null);
        }
        HttpServletRequest request = context.getRequest();
        boolean requestTransactionPassword = this.shouldValidateTransactionPassword(context, payment);
        if (requestTransactionPassword) {
            context.validateTransactionPassword();
        }
        boolean wouldRequireAuthorization = this.paymentService.wouldRequireAuthorization(payment);
        request.setAttribute("requestTransactionPassword", (Object)requestTransactionPassword);
        request.setAttribute("wouldRequireAuthorization", (Object)wouldRequireAuthorization);
        if (wouldRequireAuthorization && payment.getDate() != null) {
            throw new ValidationException("payment.error.authorizedInPast", new Object[0]);
        }
        AccountOwner from = payment.getFrom();
        AccountOwner to = payment.getTo();
        TransferType transferType = this.transferTypeService.load(payment.getTransferType().getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        BigDecimal amount = payment.getAmount();
        if (from instanceof Member) {
            from = (Member)this.elementService.load(((Member)from).getId(), new Relationship[0]);
            request.setAttribute("fromMember", (Object)from);
            payment.setFrom(from);
        }
        if (to instanceof Member) {
            to = (Member)this.elementService.load(((Member)to).getId(), new Relationship[0]);
            request.setAttribute("toMember", (Object)to);
            payment.setTo(to);
        }
        payment.setTransferType(transferType);
        request.setAttribute("unitsPattern", (Object)transferType.getFrom().getCurrency().getPattern());
        TransactionFeePreviewDTO preview = this.transactionFeeService.preview(from, to, transferType, amount);
        request.setAttribute("finalAmount", (Object)preview.getFinalAmount());
        request.setAttribute("fees", preview.getFees());
        if (!preview.getAmount().equals(preview.getFinalAmount())) {
            request.setAttribute("totalAmount", (Object)preview.getAmount());
        }
        if (isScheduled = CollectionUtils.isNotEmpty(payments = payment.getPayments())) {
            for (ScheduledPaymentDTO current : payments) {
                TransactionFeePreviewDTO currentPreview = this.transactionFeeService.preview(from, to, transferType, current.getAmount());
                current.setFinalAmount(currentPreview.getFinalAmount());
            }
        }
        request.setAttribute("isScheduled", (Object)isScheduled);
        Collection<PaymentCustomFieldValue> customValues = payment.getCustomValues();
        if (customValues != null) {
            List<PaymentCustomField> customFields = this.paymentCustomFieldService.list(transferType, false);
            Collection<CustomFieldHelper.Entry> entries = this.customFieldHelper.buildEntries(customFields, customValues);
            for (CustomFieldHelper.Entry entry : entries) {
                Object element;
                Long memberId;
                CustomField field = entry.getField();
                CustomFieldValue fieldValue = entry.getValue();
                if (field.getType() == CustomField.Type.ENUMERATED) {
                    CustomFieldPossibleValue possibleValue = fieldValue.getPossibleValue();
                    Long possibleValueId = possibleValue != null ? possibleValue.getId() : CoercionHelper.coerce(Long.class, fieldValue.getValue());
                    if (possibleValueId == null) continue;
                    fieldValue.setPossibleValue(this.paymentCustomFieldService.loadPossibleValue(possibleValueId));
                    continue;
                }
                if (field.getType() != CustomField.Type.MEMBER || (memberId = CoercionHelper.coerce(Long.class, fieldValue.getValue())) == null || !((element = this.elementService.load(memberId, new Relationship[0])) instanceof Member)) continue;
                fieldValue.setMemberValue((Member)element);
            }
            request.setAttribute("customFields", entries);
        }
    }

    @Override
    protected void validateForm(ActionContext context) {
        ConfirmPaymentForm form;
        if (this.shouldValidateTransactionPassword(context, this.validatePayment(context)) && StringUtils.isEmpty((String)(form = (ConfirmPaymentForm)((Object)context.getForm())).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }

    private boolean shouldValidateTransactionPassword(ActionContext context, DoPaymentDTO payment) {
        if (payment.getFrom() == null) {
            TransferType transferType = this.transferTypeService.load(payment.getTransferType().getId(), TransferType.Relationships.FROM);
            return context.isTransactionPasswordEnabled(transferType.getFrom());
        }
        return context.isTransactionPasswordEnabled();
    }

    private DoPaymentDTO validatePayment(ActionContext context) {
        DoPaymentDTO payment = (DoPaymentDTO)context.getSession().getAttribute("payment");
        if (payment == null) {
            throw new ValidationException();
        }
        return payment;
    }
}

