/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.payments.BasePaymentAction;
import nl.strohalm.cyclos.controls.payments.PaymentForm;
import nl.strohalm.cyclos.controls.payments.SchedulingType;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.BeanCollectionBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.AccountOwnerConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.time.DateUtils;
import org.apache.struts.action.ActionForward;

public class PaymentAction
extends BasePaymentAction {
    @Override
    protected AccountOwner getFromOwner(ActionContext context) {
        PaymentForm form = (PaymentForm)((Object)context.getForm());
        Long fromId = IdConverter.instance().valueOf(form.getFrom());
        if (fromId == null) {
            return context.getAccountOwner();
        }
        Object element = this.elementService.load(fromId, Element.Relationships.GROUP);
        if (element instanceof Member) {
            return (Member)element;
        }
        return null;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        PaymentForm form = (PaymentForm)((Object)context.getForm());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("selectMember", form.isSelectMember());
        params.put("toSystem", form.isToSystem());
        params.put("from", form.getFrom());
        return ActionHelper.redirectWithParams(context.getRequest(), super.handleSubmit(context), params);
    }

    @Override
    protected DataBinder<DoPaymentDTO> initDataBinder() {
        BeanBinder binder = (BeanBinder)super.initDataBinder();
        binder.registerBinder("to", PropertyBinder.instance(AccountOwner.class, "to", AccountOwnerConverter.instance()));
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        BeanBinder<ScheduledPaymentDTO> scheduledPayments = BeanBinder.instance(ScheduledPaymentDTO.class);
        scheduledPayments.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
        scheduledPayments.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
        binder.registerBinder("payments", BeanCollectionBinder.instance(scheduledPayments, "payments"));
        return binder;
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        super.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        PaymentForm form = (PaymentForm)((Object)context.getForm());
        String titleKey = null;
        boolean toSystem = form.isToSystem();
        boolean selectMember = form.isSelectMember();
        boolean asMember = (Boolean)request.getAttribute("asMember");
        Member fromMember = (Member)request.getAttribute("member");
        if (toSystem) {
            titleKey = asMember ? (context.isAdmin() ? "payment.title.systemMemberToSystem" : "payment.title.brokerMemberToSystem") : "payment.title.memberToSystem";
        } else if (selectMember) {
            titleKey = asMember ? (context.isAdmin() ? "payment.title.systemMemberToMember" : "payment.title.brokerMemberToMember") : (context.isAdmin() ? "payment.title.systemToMember" : "payment.title.memberToMember");
        } else {
            Object element;
            Member member = null;
            Long memberId = IdConverter.instance().valueOf(form.getTo());
            Object loggedElement = context.getElement();
            if (memberId != null && memberId != ((Entity)loggedElement).getId() && (element = this.elementService.load(memberId, Element.Relationships.USER)) instanceof Member) {
                member = (Member)element;
            }
            if (member == null) {
                throw new ValidationException();
            }
            request.setAttribute("member", member);
            titleKey = context.isAdmin() ? "payment.title.systemToMember" : "payment.title.memberToMember";
        }
        request.setAttribute("titleKey", (Object)titleKey);
        request.setAttribute("toSystem", (Object)toSystem);
        request.setAttribute("toMember", (Object)(!toSystem ? 1 : 0));
        request.setAttribute("selectMember", (Object)selectMember);
        request.setAttribute("currentTime", (Object)System.currentTimeMillis());
        request.setAttribute("fromMember", (Object)fromMember);
        boolean allowsScheduling = false;
        boolean allowsMultipleScheduling = false;
        if (context.isAdmin() && fromMember == null) {
            allowsScheduling = true;
            allowsMultipleScheduling = true;
        } else {
            MemberGroup memberGroup = fromMember == null ? ((Member)context.getAccountOwner()).getMemberGroup() : fromMember.getMemberGroup();
            MemberGroupSettings memberSettings = memberGroup.getMemberSettings();
            allowsScheduling = memberSettings.isAllowsScheduledPayments();
            allowsMultipleScheduling = memberSettings.isAllowsMultipleScheduledPayments();
        }
        if (allowsScheduling) {
            request.setAttribute("allowsScheduling", (Object)allowsScheduling);
            request.setAttribute("allowsMultipleScheduling", (Object)allowsMultipleScheduling);
            EnumSet<SchedulingType> schedulingTypes = EnumSet.of(SchedulingType.IMMEDIATELY, SchedulingType.SINGLE_FUTURE);
            if (allowsMultipleScheduling) {
                schedulingTypes.add(SchedulingType.MULTIPLE_FUTURE);
            }
            request.setAttribute("schedulingTypes", schedulingTypes);
            request.setAttribute("schedulingFields", Arrays.asList(TimePeriod.Field.MONTHS, TimePeriod.Field.WEEKS, TimePeriod.Field.DAYS));
        }
    }

    @Override
    protected DoPaymentDTO resolvePaymentDTO(ActionContext context) {
        List<ScheduledPaymentDTO> payments;
        DoPaymentDTO dto = super.resolvePaymentDTO(context);
        dto.setContext(TransactionContext.PAYMENT);
        PaymentForm form = (PaymentForm)((Object)context.getForm());
        if (form.isToSystem()) {
            dto.setTo(SystemAccountOwner.instance());
        }
        if ((payments = dto.getPayments()) != null && payments.size() == 1) {
            ScheduledPaymentDTO payment = payments.get(0);
            if (DateUtils.isSameDay((Calendar)Calendar.getInstance(), (Calendar)payment.getDate())) {
                dto.setPayments(null);
            }
        }
        return dto;
    }

    @Override
    protected TransferTypeQuery resolveTransferTypeQuery(ActionContext context) {
        HttpServletRequest request;
        Collection currencies;
        PaymentForm form = (PaymentForm)((Object)context.getForm());
        Long fromId = IdConverter.instance().valueOf(form.getFrom());
        Long toId = IdConverter.instance().valueOf(form.getTo());
        boolean fromMe = fromId == null;
        boolean asMember = !fromMe;
        boolean toSpecificMember = !form.isSelectMember() && !form.isToSystem();
        boolean toUnknownMember = form.isSelectMember();
        boolean toSystem = form.isToSystem();
        if (toUnknownMember || asMember && !toSystem) {
            return null;
        }
        Currency currency = CoercionHelper.coerce(Currency.class, form.getCurrency());
        if (currency == null && !(currencies = (Collection)(request = context.getRequest()).getAttribute("currencies")).isEmpty()) {
            currency = (Currency)currencies.iterator().next();
        }
        TransferTypeQuery query = new TransferTypeQuery();
        query.setChannel("web");
        query.setContext(TransactionContext.PAYMENT);
        query.setUsePriority(true);
        if (fromMe) {
            query.setGroup((Group)context.getGroup());
            query.setFromOwner(context.getAccountOwner());
        } else {
            query.setBy((Element)context.getElement());
            query.setFromOwner(EntityHelper.reference(Member.class, fromId));
        }
        if (toSystem) {
            query.setToOwner(SystemAccountOwner.instance());
        } else if (toSpecificMember) {
            query.setToOwner(EntityHelper.reference(Member.class, toId));
        }
        return query;
    }
}

