/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.payments.BasePaymentAction;
import nl.strohalm.cyclos.controls.payments.SelfPaymentForm;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.DoPaymentDTO;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.utils.conversion.IdConverter;

public class SelfPaymentAction
extends BasePaymentAction {
    @Override
    protected AccountOwner getFromOwner(ActionContext context) {
        SelfPaymentForm form = (SelfPaymentForm)((Object)context.getForm());
        Long memberId = IdConverter.instance().valueOf(form.getFrom());
        if (memberId == null) {
            return context.getAccountOwner();
        }
        return (Member)this.elementService.load(memberId, new Relationship[0]);
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        super.prepareForm(context);
        HttpServletRequest request = context.getRequest();
        boolean asMember = (Boolean)request.getAttribute("asMember");
        String titleKey = asMember ? "payment.title.asMemberToSelf" : (context.isAdmin() ? "payment.title.systemToSystem" : "payment.title.memberToSelf");
        request.setAttribute("titleKey", (Object)titleKey);
    }

    @Override
    protected DoPaymentDTO resolvePaymentDTO(ActionContext context) {
        DoPaymentDTO dto = super.resolvePaymentDTO(context);
        dto.setContext(TransactionContext.SELF_PAYMENT);
        dto.setTo(this.getFromOwner(context));
        dto.setFrom(this.getFromOwner(context));
        dto.setChannel(null);
        return dto;
    }

    @Override
    protected TransferTypeQuery resolveTransferTypeQuery(ActionContext context) {
        SelfPaymentForm form = (SelfPaymentForm)((Object)context.getForm());
        Long memberId = IdConverter.instance().valueOf(form.getFrom());
        TransferTypeQuery query = new TransferTypeQuery();
        query.setUsePriority(true);
        query.setContext(TransactionContext.SELF_PAYMENT);
        AccountOwner owner = this.getFromOwner(context);
        query.setFromOwner(owner);
        query.setToOwner(owner);
        if (memberId != null) {
            query.setBy((Element)context.getElement());
        } else {
            query.setGroup((Group)context.getGroup());
        }
        return query;
    }
}

