/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseAction;
import nl.strohalm.cyclos.controls.payments.SuccessfulPaymentForm;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;

public class SuccessfulPaymentAction
extends BaseAction {
    private static final Relationship[] FETCH = new Relationship[]{RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), Payment.Relationships.TYPE};
    private PaymentService paymentService;

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Override
    protected ActionForward executeAction(ActionContext context) throws Exception {
        SuccessfulPaymentForm form = (SuccessfulPaymentForm)((Object)context.getForm());
        long transferId = form.getTransferId();
        if (transferId <= 0L) {
            throw new ValidationException();
        }
        HttpServletRequest request = context.getRequest();
        Transfer transfer = this.paymentService.load(transferId, FETCH);
        boolean toSystem = false;
        boolean selfPayment = false;
        boolean pendingAuthorization = false;
        boolean selectMember = false;
        boolean nextAttempt = false;
        Account from = transfer.getFrom();
        Member fromMember = null;
        if (from instanceof MemberAccount) {
            fromMember = ((MemberAccount)from).getMember();
        }
        Account to = transfer.getTo();
        Member toMember = null;
        if (to instanceof MemberAccount) {
            toMember = ((MemberAccount)to).getMember();
        }
        Member relatedMember = null;
        if (fromMember != null && !((Entity)context.getElement()).equals(fromMember)) {
            relatedMember = fromMember;
        } else if (toMember != null && !((Entity)context.getElement()).equals(toMember)) {
            relatedMember = toMember;
        }
        pendingAuthorization = transfer.getProcessDate() == null;
        selectMember = CoercionHelper.coerce(Boolean.TYPE, form.getSelectMember());
        toSystem = to instanceof SystemAccount;
        selfPayment = from.getOwner().equals(to.getOwner());
        request.setAttribute("transfer", (Object)transfer);
        if (relatedMember != null) {
            request.setAttribute("relatedMember", (Object)relatedMember.getId());
        }
        if (fromMember != null && !((Entity)context.getElement()).equals(fromMember)) {
            request.setAttribute("from", (Object)fromMember.getId());
        }
        if (toMember != null) {
            request.setAttribute("to", (Object)toMember.getId());
        }
        request.setAttribute("selectMember", (Object)selectMember);
        request.setAttribute("pendingAuthorization", (Object)pendingAuthorization);
        request.setAttribute("nextAttempt", (Object)0);
        request.setAttribute("toSystem", (Object)toSystem);
        request.setAttribute("selfPayment", (Object)selfPayment);
        return context.getInputForward();
    }
}

