/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments.authorization;

import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.payments.authorization.BaseTransferAuthorizationAction;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.services.transactions.exceptions.AlreadyAuthorizedException;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class AuthorizePaymentAction
extends BaseTransferAuthorizationAction {
    @Override
    protected Transfer performAction(ActionContext context) {
        TransferAuthorizationDTO transferAuthorizationDto = this.resolveAuthorizationDto(context);
        Transfer transfer = transferAuthorizationDto.getTransfer();
        this.checkTransactionPassword(context, transfer);
        try {
            transfer = this.transferAuthorizationService.authorize(transferAuthorizationDto);
            context.sendMessage(transfer.getProcessDate() == null ? "payment.nextAuthorizationLevel" : "payment.authorized", new Object[0]);
        }
        catch (AlreadyAuthorizedException e) {
            throw new ValidationException("transferAuthorization.error.alreadyAuthorized", new Object[0]);
        }
        return transfer;
    }
}

