/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments.authorization;

import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.accounts.details.ViewTransactionAction;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferAuthorizationDTO;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.ReferenceConverter;
import org.apache.struts.action.ActionForward;

public abstract class BaseTransferAuthorizationAction
extends ViewTransactionAction {
    private DataBinder<TransferAuthorizationDTO> dataBinder;

    public DataBinder<TransferAuthorizationDTO> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<TransferAuthorizationDTO> binder = BeanBinder.instance(TransferAuthorizationDTO.class);
            binder.registerBinder("transfer", PropertyBinder.instance(Transfer.class, "transferId", ReferenceConverter.instance(Transfer.class)));
            binder.registerBinder("comments", PropertyBinder.instance(String.class, "comments"));
            binder.registerBinder("showToMember", PropertyBinder.instance(Boolean.TYPE, "showToMember"));
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        TransferAuthorizationDTO transferAuthorizationDto = this.resolveAuthorizationDto(context);
        if (this.shouldValidateTransactionPassword(context, transferAuthorizationDto.getTransfer())) {
            context.validateTransactionPassword();
        }
        this.performAction(context);
        return ActionHelper.redirectWithParams(context.getRequest(), context.getSuccessForward(), this.resolveForwardParams(context));
    }

    protected void initializeTransfer(TransferAuthorizationDTO transferAuthorizationDto) {
        Transfer transfer = transferAuthorizationDto.getTransfer();
        transfer = this.paymentService.load(transfer.getId(), FETCH);
        transferAuthorizationDto.setTransfer(transfer);
    }

    protected abstract Transfer performAction(ActionContext var1);

    protected TransferAuthorizationDTO resolveAuthorizationDto(ActionContext context) {
        TransferAuthorizationDTO transferAuthorizationDto = this.getDataBinder().readFromString(context.getForm());
        this.initializeTransfer(transferAuthorizationDto);
        return transferAuthorizationDto;
    }
}

