/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments.conversionsimulation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.payments.conversionsimulation.SimulateConversionForm;
import nl.strohalm.cyclos.controls.reports.statistics.graphs.StatisticalDataProducer;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.accounts.AccountService;
import nl.strohalm.cyclos.services.accounts.rates.ConversionSimulationDTO;
import nl.strohalm.cyclos.services.stats.StatisticalResultDTO;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewForRatesDTO;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.struts.action.ActionForward;
import org.jfree.chart.plot.Marker;

public class SimulateConversionAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private AccountService accountService;
    private TransferTypeService transferTypeService;
    private PaymentService paymentService;
    private DataBinder<ConversionSimulationDTO> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        SimulateConversionForm form = (SimulateConversionForm)((Object)context.getForm());
        if (form.isReloadData()) {
            return this.handleDisplay(context);
        }
        this.reloadForm(context);
        ConversionSimulationDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        Member member = this.resolveMember(context);
        boolean myAccount = member.equals(context.getAccountOwner());
        this.showResults(request, dto, myAccount);
        this.showGraph(context, dto);
        return context.getInputForward();
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        boolean firstLoad;
        HttpServletRequest request = context.getRequest();
        SimulateConversionForm form = (SimulateConversionForm)((Object)context.getForm());
        boolean bl = firstLoad = !form.isReloadData() && request.getParameter("advanced") == null;
        if (firstLoad) {
            if (context.isAdmin()) {
                form.setAdvanced(true);
            } else {
                form.setAdvanced(false);
            }
        }
        this.reloadForm(context);
    }

    @Override
    protected void validateForm(ActionContext context) {
        SimulateConversionForm form = (SimulateConversionForm)((Object)context.getForm());
        ConversionSimulationDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        this.paymentService.validate(dto);
    }

    private void attachLabels(StatisticalResultDTO rawDataObject, ConversionSimulationDTO dto, ActionContext context) {
        Marker[] markers = rawDataObject.getDomainMarkers();
        if (markers != null) {
            for (Marker marker : markers) {
                String key = marker.getLabel();
                if (key == null) continue;
                String title = context.message(key, new Object[0]);
                marker.setLabel(title);
            }
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TransferType transferType = dto.getTransferType();
        transferType = this.transferTypeService.load(transferType.getId(), TransferType.Relationships.TRANSACTION_FEES, RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY));
        String unitsPattern = transferType.getFrom().getCurrency().getPattern();
        UnitsConverter numberConverter = localSettings.getUnitsConverter(unitsPattern);
        String numberString = ((NumberConverter)numberConverter).toString(dto.getAmount());
        String subTitle = context.message("conversionSimulation.result.graph.subtitle", numberString);
        rawDataObject.setSubTitle(subTitle);
    }

    private List<TransferType> filterTransferTypesByAccount(MemberAccount account, Collection<TransferType> allTransferTypes) {
        ArrayList<TransferType> result = new ArrayList<TransferType>(allTransferTypes.size());
        for (TransferType currentTT : allTransferTypes) {
            if (!account.getType().getFromTransferTypes().contains(currentTT)) continue;
            result.add(currentTT);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<ConversionSimulationDTO> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<ConversionSimulationDTO> binder = BeanBinder.instance(ConversionSimulationDTO.class);
                binder.registerBinder("account", PropertyBinder.instance(MemberAccount.class, "account"));
                binder.registerBinder("transferType", PropertyBinder.instance(TransferType.class, "transferType"));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                binder.registerBinder("useActualRates", PropertyBinder.instance(Boolean.TYPE, "useActualRates"));
                binder.registerBinder("arate", PropertyBinder.instance(BigDecimal.class, "arate", localSettings.getNumberConverter()));
                binder.registerBinder("drate", PropertyBinder.instance(BigDecimal.class, "drate", localSettings.getNumberConverter()));
                binder.registerBinder("date", PropertyBinder.instance(Calendar.class, "date", localSettings.getRawDateConverter()));
                binder.registerBinder("graph", PropertyBinder.instance(Boolean.TYPE, "graph"));
                this.dataBinder = binder;
            }
            DataBinder<ConversionSimulationDTO> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void reloadForm(ActionContext context) {
        HttpServletRequest request = context.getRequest();
        SimulateConversionForm form = (SimulateConversionForm)((Object)context.getForm());
        Member member = this.resolveMember(context);
        boolean myAccount = member.equals(context.getAccountOwner());
        Collection<TransferType> allowedTTs = this.resolveAllowedTTs(context, myAccount);
        ConversionSimulationDTO dto = this.getDataBinder().readFromString(form.getSimulation());
        MemberAccount account = dto.getAccount();
        ArrayList<Account> allowedAccounts = new ArrayList<Account>(this.accountService.getAccountsFromTTs(member, allowedTTs, TransferType.Direction.FROM));
        boolean changed = false;
        if (account == null) {
            account = (MemberAccount)this.accountService.getDefaultAccountFromList(member, allowedAccounts);
            changed = true;
        }
        account = (MemberAccount)this.accountService.load(account.getId(), new Relationship[0]);
        List<TransferType> transferTypes = this.filterTransferTypesByAccount(account, allowedTTs);
        ConversionSimulationDTO defaultDto = this.paymentService.getDefaultConversionDTO(account, transferTypes);
        if (changed || form.isReloadData()) {
            dto = defaultDto;
        }
        this.getDataBinder().writeAsString(form.getSimulation(), dto);
        request.setAttribute("member", (Object)member);
        request.setAttribute("account", (Object)account);
        request.setAttribute("myAccount", (Object)myAccount);
        request.setAttribute("accounts", allowedAccounts);
        if (allowedAccounts.size() == 1) {
            request.setAttribute("singleAccount", allowedAccounts.get(0));
        }
        request.setAttribute("arateDefault", (Object)defaultDto.getArate());
        request.setAttribute("drateDefault", (Object)defaultDto.getDrate());
        request.setAttribute("tts", transferTypes);
        if (transferTypes.size() == 1) {
            request.setAttribute("singleTT", (Object)transferTypes.get(0));
        }
    }

    private Collection<TransferType> resolveAllowedTTs(ActionContext context, boolean myAccount) {
        Collection<TransferType> allowedTTs;
        Object loggedUserGroup = context.getGroup();
        if (!myAccount && loggedUserGroup instanceof BrokerGroup) {
            loggedUserGroup = this.groupService.load(((Entity)loggedUserGroup).getId(), BrokerGroup.Relationships.BROKER_CONVERSION_SIMULATION_TTS);
            allowedTTs = ((BrokerGroup)loggedUserGroup).getBrokerConversionSimulationTTs();
        } else {
            loggedUserGroup = this.groupService.load(((Entity)loggedUserGroup).getId(), Group.Relationships.CONVERSION_SIMULATION_TTS);
            allowedTTs = ((Group)loggedUserGroup).getConversionSimulationTTs();
        }
        return allowedTTs;
    }

    private Member resolveMember(ActionContext context) {
        SimulateConversionForm form = (SimulateConversionForm)((Object)context.getForm());
        Member member = null;
        long memberId = form.getMemberId();
        if (memberId > 0L) {
            try {
                member = (Member)this.elementService.load(memberId, new Relationship[0]);
            }
            catch (Exception e) {
                member = null;
            }
        }
        if (member == null && !context.isAdmin()) {
            member = (Member)context.getAccountOwner();
        }
        if (member == null) {
            throw new ValidationException();
        }
        return member;
    }

    private void showGraph(ActionContext context, ConversionSimulationDTO dto) {
        if (dto.isGraph()) {
            HttpServletRequest request = context.getRequest();
            ArrayList<StatisticalDataProducer> dataList = new ArrayList<StatisticalDataProducer>();
            StatisticalResultDTO rawDataObject = this.paymentService.getSimulateConversionGraph(dto);
            this.attachLabels(rawDataObject, dto, context);
            StatisticalDataProducer producer = new StatisticalDataProducer(rawDataObject, context);
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            producer.setSettings(localSettings);
            dataList.add(producer);
            request.setAttribute("dataList", dataList);
        }
    }

    private void showResults(HttpServletRequest request, ConversionSimulationDTO dto, boolean myAccount) {
        Calendar now = Calendar.getInstance();
        if (dto.getDate() == null) {
            dto.setDate(now);
        }
        Calendar equalizedProcessDate = DateHelper.equalizeTime(dto.getDate(), now);
        dto.setDate(equalizedProcessDate);
        TransactionFeePreviewForRatesDTO result = this.paymentService.simulateConversion(dto);
        request.setAttribute("feelessAmount", (Object)result.getFinalAmount());
        request.setAttribute("totalAmount", (Object)result.getAmount());
        request.setAttribute("totalFees", (Object)result.getRatesAsFeePercentage());
        request.setAttribute("totalFeeAmount", (Object)result.getTotalFeeAmount());
        request.setAttribute("fees", result.getFees());
        ArrayList<BigDecimal> feePercentages = new ArrayList<BigDecimal>(result.getFees().size());
        for (TransactionFee fee : result.getFees().keySet()) {
            feePercentages.add(fee.getAmount().getValue());
        }
        request.setAttribute("feePercentages", feePercentages);
        TransferType transferType = dto.getTransferType();
        transferType = this.transferTypeService.load(transferType.getId(), TransferType.Relationships.TRANSACTION_FEES, RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY));
        request.setAttribute("unitsPattern", (Object)transferType.getFrom().getCurrency().getPattern());
        request.setAttribute("usedARate", (Object)result.getARate());
        request.setAttribute("usedDRate", (Object)result.getDRate());
        if (transferType.isHavingRatedFees()) {
            request.setAttribute("usedDate", (Object)equalizedProcessDate);
        }
    }
}

