/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments.request;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.payments.request.RequestPaymentForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentRequestTicket;
import nl.strohalm.cyclos.entities.accounts.transactions.TicketQuery;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsEvent;
import nl.strohalm.cyclos.services.access.ChannelService;
import nl.strohalm.cyclos.services.accounts.CurrencyService;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.services.transactions.exceptions.AuthorizedPaymentInPastException;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transactions.exceptions.InvalidChannelException;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class RequestPaymentAction
extends BaseFormAction
implements LocalSettingsChangeListener {
    private ChannelService channelService;
    private CurrencyService currencyService;
    private TicketService ticketService;
    private DataBinder<PaymentRequestTicket> dataBinder;
    private ReadWriteLock lock = new ReentrantReadWriteLock(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLocalSettingsUpdate(LocalSettingsEvent event) {
        try {
            this.lock.writeLock().lock();
            this.dataBinder = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Inject
    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    @Inject
    public void setCurrencyService(CurrencyService currencyService) {
        this.currencyService = currencyService;
    }

    @Inject
    public void setTicketService(TicketService ticketService) {
        this.ticketService = ticketService;
    }

    @Override
    protected void formAction(ActionContext context) throws Exception {
        PaymentRequestTicket ticket = this.resolveTicket(context);
        try {
            ticket = this.ticketService.generate(ticket);
            context.sendMessage("paymentRequest.sent", ticket.getFrom().getName());
        }
        catch (CreditsException e) {
            throw new ValidationException(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (InvalidChannelException e) {
            throw new ValidationException("paymentRequest.error.invalidChannel", e.getUsername(), e.getChannelName());
        }
        catch (UnexpectedEntityException e) {
            throw new ValidationException("payment.error.invalidTransferType", new Object[0]);
        }
        catch (AuthorizedPaymentInPastException e) {
            throw new ValidationException("payment.error.authorizedInPast", new Object[0]);
        }
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        HttpServletRequest request = context.getRequest();
        Member member = (Member)context.getAccountOwner();
        request.setAttribute("toMember", (Object)member);
        MemberGroup group = (MemberGroup)this.groupService.load(member.getMemberGroup().getId(), MemberGroup.Relationships.REQUEST_PAYMENT_BY_CHANNELS);
        List<Currency> currencies = this.currencyService.listByMemberGroup(group);
        if (currencies.isEmpty()) {
            throw new ValidationException("payment.error.noTransferType", new Object[0]);
        }
        if (currencies.size() == 1) {
            request.setAttribute("singleCurrency", (Object)currencies.iterator().next());
        }
        request.setAttribute("currencies", currencies);
        ArrayList<Channel> channels = new ArrayList<Channel>(group.getRequestPaymentByChannels());
        Iterator it = channels.iterator();
        while (it.hasNext()) {
            if (((Channel)it.next()).isPaymentRequestSupported()) continue;
            it.remove();
        }
        if (channels.isEmpty()) {
            throw new ValidationException("paymentRequest.error.noChannels", new Object[0]);
        }
        if (channels.size() == 1) {
            request.setAttribute("singleChannel", channels.iterator().next());
        }
        request.setAttribute("channels", channels);
        RequestHelper.storeEnum(request, TicketQuery.GroupedStatus.class, "status");
    }

    @Override
    protected void validateForm(ActionContext context) {
        PaymentRequestTicket ticket = this.resolveTicket(context);
        this.ticketService.validate(ticket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataBinder<PaymentRequestTicket> getDataBinder() {
        try {
            this.lock.readLock().lock();
            if (this.dataBinder == null) {
                LocalSettings localSettings = this.settingsService.getLocalSettings();
                BeanBinder<PaymentRequestTicket> binder = BeanBinder.instance(PaymentRequestTicket.class);
                binder.registerBinder("from", PropertyBinder.instance(Member.class, "from"));
                binder.registerBinder("amount", PropertyBinder.instance(BigDecimal.class, "amount", localSettings.getNumberConverter()));
                binder.registerBinder("currency", PropertyBinder.instance(Currency.class, "currency"));
                binder.registerBinder("toChannel", PropertyBinder.instance(Channel.class, "toChannel"));
                binder.registerBinder("description", PropertyBinder.instance(String.class, "description"));
                this.dataBinder = binder;
            }
            DataBinder<PaymentRequestTicket> dataBinder = this.dataBinder;
            return dataBinder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private PaymentRequestTicket resolveTicket(ActionContext context) {
        RequestPaymentForm form = (RequestPaymentForm)((Object)context.getForm());
        PaymentRequestTicket ticket = this.getDataBinder().readFromString(form.getTicket());
        ticket.setTo((Member)context.getAccountOwner());
        ticket.setFromChannel(this.channelService.loadByInternalName("web"));
        return ticket;
    }
}

