/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments.request;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseQueryAction;
import nl.strohalm.cyclos.controls.payments.request.SearchPaymentRequestsForm;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.transactions.Ticket;
import nl.strohalm.cyclos.entities.accounts.transactions.TicketQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.TicketService;
import nl.strohalm.cyclos.utils.binding.BeanBinder;
import nl.strohalm.cyclos.utils.binding.DataBinder;
import nl.strohalm.cyclos.utils.binding.DataBinderHelper;
import nl.strohalm.cyclos.utils.binding.PropertyBinder;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class SearchPaymentRequestsAction
extends BaseQueryAction {
    private TicketService ticketService;
    private DataBinder<TicketQuery> dataBinder;

    @Inject
    public void setTicketService(TicketService ticketService) {
        this.ticketService = ticketService;
    }

    @Override
    protected void executeQuery(ActionContext context, QueryParameters queryParameters) {
        TicketQuery query = (TicketQuery)queryParameters;
        context.getRequest().setAttribute("tickets", this.ticketService.search(query));
    }

    @Override
    protected QueryParameters prepareForm(ActionContext context) {
        MemberGroup group;
        Collection<Channel> channels;
        HttpServletRequest request = context.getRequest();
        SearchPaymentRequestsForm form = (SearchPaymentRequestsForm)((Object)context.getForm());
        TicketQuery query = this.getDataBinder().readFromString(form.getQuery());
        query.setNature(Ticket.Nature.PAYMENT_REQUEST);
        Member to = (Member)context.getAccountOwner();
        query.setTo(to);
        if (query.getGroupedStatus() == null) {
            query.setGroupedStatus(TicketQuery.GroupedStatus.OK_PENDING);
        }
        if ((channels = (group = (MemberGroup)this.groupService.load(to.getMemberGroup().getId(), MemberGroup.Relationships.REQUEST_PAYMENT_BY_CHANNELS)).getRequestPaymentByChannels()).isEmpty()) {
            throw new ValidationException("paymentRequest.error.noChannels", new Object[0]);
        }
        if (channels.size() == 1) {
            request.setAttribute("singleChannel", (Object)channels.iterator().next());
        }
        return query;
    }

    private DataBinder<TicketQuery> getDataBinder() {
        if (this.dataBinder == null) {
            BeanBinder<TicketQuery> binder = BeanBinder.instance(TicketQuery.class);
            binder.registerBinder("groupedStatus", PropertyBinder.instance(TicketQuery.GroupedStatus.class, "groupedStatus"));
            binder.registerBinder("from", PropertyBinder.instance(Member.class, "from"));
            binder.registerBinder("pageParameters", DataBinderHelper.pageBinder());
            this.dataBinder = binder;
        }
        return this.dataBinder;
    }
}

