/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.controls.payments.scheduled;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.controls.ActionContext;
import nl.strohalm.cyclos.controls.BaseFormAction;
import nl.strohalm.cyclos.controls.payments.scheduled.ScheduledPaymentForm;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.ScheduledPayment;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.transactions.PaymentService;
import nl.strohalm.cyclos.services.transactions.ScheduledPaymentService;
import nl.strohalm.cyclos.services.transactions.exceptions.CreditsException;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;

public class ConfirmScheduledPaymentAction
extends BaseFormAction {
    private PaymentService paymentService;
    private ScheduledPaymentService scheduledPaymentService;
    private TransactionFeeService transactionFeeService;
    private TransferTypeService transferTypeService;

    @Inject
    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    @Inject
    public void setScheduledPaymentService(ScheduledPaymentService scheduledPaymentService) {
        this.scheduledPaymentService = scheduledPaymentService;
    }

    @Inject
    public void setTransactionFeeService(TransactionFeeService transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Inject
    public void setTransferTypeService(TransferTypeService transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    protected ActionForward handleSubmit(ActionContext context) throws Exception {
        Transfer transfer = this.resolveTransfer(context);
        if (this.shouldValidateTransactionPassword(context, transfer)) {
            ScheduledPaymentForm form = (ScheduledPaymentForm)((Object)context.getForm());
            context.checkTransactionPassword(form.getTransactionPassword());
        }
        try {
            transfer = this.scheduledPaymentService.processTransfer(transfer);
        }
        catch (CreditsException e) {
            return context.sendError(this.actionHelper.resolveErrorKey(e), this.actionHelper.resolveParameters(e));
        }
        catch (UnexpectedEntityException e) {
            return context.sendError("payment.error.invalidTransferType", new Object[0]);
        }
        return ActionHelper.redirectWithParam(context.getRequest(), context.getSuccessForward(), "paymentId", transfer.getScheduledPayment().getId());
    }

    @Override
    protected void prepareForm(ActionContext context) throws Exception {
        Transfer transfer = this.resolveTransfer(context);
        HttpServletRequest request = context.getRequest();
        boolean requestTransactionPassword = this.shouldValidateTransactionPassword(context, transfer);
        if (requestTransactionPassword) {
            context.validateTransactionPassword();
        }
        request.setAttribute("requestTransactionPassword", (Object)requestTransactionPassword);
        request.setAttribute("wouldRequireAuthorization", (Object)this.paymentService.wouldRequireAuthorization(transfer));
        int transferNumber = this.getTransferNumber(transfer);
        int numberOfTransfers = this.getNumberOfTransfer(transfer);
        request.setAttribute("transferNumber", (Object)transferNumber);
        request.setAttribute("numberOfTransfers", (Object)numberOfTransfers);
        AccountOwner from = transfer.getFromOwner();
        AccountOwner to = transfer.getToOwner();
        TransferType transferType = this.transferTypeService.load(transfer.getType().getId(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY), TransferType.Relationships.TO);
        BigDecimal amount = transfer.getAmount();
        if (from instanceof Member) {
            request.setAttribute("fromMember", (Object)from);
        }
        if (to instanceof Member) {
            request.setAttribute("toMember", (Object)to);
        }
        transfer.setType(transferType);
        request.setAttribute("unitsPattern", (Object)transferType.getFrom().getCurrency().getPattern());
        TransactionFeePreviewDTO preview = this.transactionFeeService.preview(from, to, transferType, amount);
        request.setAttribute("finalAmount", (Object)preview.getFinalAmount());
        request.setAttribute("fees", preview.getFees());
        request.setAttribute("transfer", (Object)transfer);
    }

    @Override
    protected void validateForm(ActionContext context) {
        ScheduledPaymentForm form;
        if (this.shouldValidateTransactionPassword(context, this.resolveTransfer(context)) && StringUtils.isEmpty((String)(form = (ScheduledPaymentForm)((Object)context.getForm())).getTransactionPassword())) {
            throw new ValidationException("_transactionPassword", "login.transactionPassword", new RequiredError(new Object[0]));
        }
    }

    private int getNumberOfTransfer(Transfer transfer) {
        ScheduledPayment scheduledPayment = transfer.getScheduledPayment();
        return scheduledPayment.getTransfers().size();
    }

    private int getTransferNumber(Transfer transfer) {
        ScheduledPayment scheduledPayment = transfer.getScheduledPayment();
        int transferNumber = 0;
        for (Transfer currentTransfer : scheduledPayment.getTransfers()) {
            ++transferNumber;
            if (!currentTransfer.equals(transfer)) continue;
            break;
        }
        return transferNumber;
    }

    private Transfer resolveTransfer(ActionContext context) {
        ScheduledPaymentForm form = (ScheduledPaymentForm)((Object)context.getForm());
        Long transferId = form.getTransferId();
        if (transferId <= 0L) {
            throw new ValidationException();
        }
        return this.paymentService.load(transferId, RelationshipHelper.nested(Payment.Relationships.FROM, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Payment.Relationships.TO, MemberAccount.Relationships.MEMBER), RelationshipHelper.nested(Transfer.Relationships.SCHEDULED_PAYMENT, ScheduledPayment.Relationships.TRANSFERS));
    }

    private boolean shouldValidateTransactionPassword(ActionContext context, Transfer transfer) {
        TransferType transferType = this.transferTypeService.load(transfer.getType().getId(), TransferType.Relationships.FROM);
        return context.isTransactionPasswordEnabled(transferType.getFrom());
    }
}

